/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission.util;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.pojo.DWSecurityToken;
import com.digiwin.gateway.service.permission.util.AESUtil;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;

public final class DWSecurityTokenUtil {
    static final long EFFECTIVE_TIME = 600000L;
    static final String KEY_USER_SID = "userSid";
    static final String KEY_TENANT_SID = "tenantSid";

    DWSecurityTokenUtil() {
    }

    public static String generateSecurityToken(DWSecurityContext context) throws Exception {
        DWSecurityToken securityToken = new DWSecurityToken();
        Map<String, Object> profile = context.getProfile();
        if (Objects.nonNull(profile)) {
            if (Objects.nonNull(profile.get(KEY_USER_SID))) {
                profile.put(KEY_USER_SID, Objects.toString(profile.get(KEY_USER_SID)));
            }
            if (Objects.nonNull(profile.get(KEY_TENANT_SID))) {
                profile.put(KEY_TENANT_SID, Objects.toString(profile.get(KEY_TENANT_SID)));
            }
        }
        securityToken.setContext(context);
        securityToken.setExpirationTime(Instant.now().toEpochMilli() + 600000L);
        return AESUtil.encrypt(DWGsonProvider.getGson().toJson((Object)securityToken));
    }

    public static DWSecurityToken parseSecurityToken(String securityToken) throws Exception {
        try {
            String decryptToken = AESUtil.decrypt(securityToken);
            DWSecurityToken token = (DWSecurityToken)DWGsonProvider.getGson().fromJson(decryptToken, DWSecurityToken.class);
            DWSecurityContext context = token.getContext();
            Map<String, Object> profile = context.getProfile();
            if (Objects.nonNull(profile)) {
                if (Objects.nonNull(profile.get(KEY_USER_SID))) {
                    profile.put(KEY_USER_SID, Long.parseLong(Objects.toString(profile.get(KEY_USER_SID))));
                }
                if (Objects.nonNull(profile.get(KEY_TENANT_SID))) {
                    profile.put(KEY_TENANT_SID, Long.parseLong(Objects.toString(profile.get(KEY_TENANT_SID))));
                }
            }
            return token;
        }
        catch (Exception e) {
            throw new DWRuntimeException("\u65e0\u6548\u7684security-token\uff01\uff01");
        }
    }
}

