/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission;

import com.digiwin.service.permission.DWSecurityTokenGenerator;
import com.digiwin.service.permission.pojo.DWSecurityContext;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class DWSecurityInterceptor
implements HttpRequestInterceptor {
    private static final Log log = LogFactory.getLog(DWSecurityInterceptor.class);

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        try {
            String securityToken = DWSecurityTokenGenerator.generateSecurityToken((DWSecurityContext)securityContext);
            request.addHeader("security-token", securityToken);
            log.debug((Object)String.format("http request header added security-token [%s]\u3002", securityToken));
        }
        catch (Exception e) {
            log.error((Object)("create security-token error: " + e.getMessage()), (Throwable)e);
        }
    }
}

