/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission;

import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.DWSecurityToken;
import com.digiwin.gateway.service.permission.util.DWSecurityTokenUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWSecurityContextInitFilter
implements Filter {
    private static final Log log = LogFactory.getLog(DWSecurityContextInitFilter.class);
    public static final String KEY_SECURITY_TOKEN = "security-token";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        securityContext.remove();
        String securityToken = req.getHeader(KEY_SECURITY_TOKEN);
        if (null != securityToken && !securityToken.trim().isEmpty()) {
            try {
                DWSecurityToken securityTokenBean = DWSecurityTokenUtil.parseSecurityToken((String)securityToken);
                DWSecurityContext context = securityTokenBean.getContext();
                DWSecurityContext.setSecurityContext((DWSecurityContext)context);
                log.debug((Object)("\u9084\u539f\u5b89\u5168\u4e0a\u4e0b\u6587\u3002" + context.toString()));
                Map profile = context.getProfile();
                DWSecurityContext.getSecurityContext().setProfile(profile);
            }
            catch (Exception e) {
                log.warn((Object)String.format("\u4f7f\u7528[%s]\u9084\u539f\u5b89\u5168\u4e0a\u4e0b\u6587\u6642\u51fa\u932f, \u4f7f\u7528\u5e73\u53f0\u9ed8\u8a8d\u5b89\u5168\u4e0a\u4e0b\u6587", securityToken), (Throwable)e);
            }
        }
        chain.doFilter(request, response);
    }
}

