/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission.util;

import com.digiwin.gateway.service.permission.util.DWSecurityRequestWrapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class DWSecurityRequestUtil {
    static final String KEY_TABLE_NAME = "tableName";
    static final String KEY_QUERY_INFO = "queryInfo";
    static final String KEY_DATA_SET = "dataset";

    DWSecurityRequestUtil() {
    }

    public static Set<String> getTableNames(HttpServletRequest request) throws IOException {
        HashSet<String> result = new HashSet<String>();
        DWSecurityRequestWrapper req = new DWSecurityRequestWrapper(request);
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            if (KEY_TABLE_NAME.equals(key)) {
                result.addAll(Arrays.asList((String[])entry.getValue()));
                continue;
            }
            if (!KEY_QUERY_INFO.equals(key)) continue;
            String[] values = (String[])entry.getValue();
            result.addAll(DWSecurityRequestUtil.parseQueryStr(values));
        }
        String body = new String(req.getBody(), StandardCharsets.UTF_8);
        result.addAll(DWSecurityRequestUtil.parseBody(body));
        return result;
    }

    static Set<String> parseQueryStr(String[] paramValues) {
        HashSet<String> result = new HashSet<String>();
        for (String value : paramValues) {
            String tableName;
            JsonObject jsonObj = JsonParser.parseString((String)value).getAsJsonObject();
            if (!jsonObj.has(KEY_TABLE_NAME) || !Objects.nonNull(tableName = jsonObj.get(KEY_TABLE_NAME).getAsString())) continue;
            result.add(tableName);
        }
        return result;
    }

    static Set<String> parseBody(String body) {
        JsonObject dataset;
        JsonObject jsonObj;
        if (Objects.nonNull(body) && !body.trim().isEmpty() && (jsonObj = JsonParser.parseString((String)body).getAsJsonObject()).has(KEY_DATA_SET) && Objects.nonNull(dataset = jsonObj.getAsJsonObject(KEY_DATA_SET))) {
            return dataset.keySet();
        }
        return new HashSet<String>();
    }
}

