/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.registry.utils;

import com.digiwin.app.registry.data.MCText;
import com.digiwin.app.registry.enumeration.DOCleverItemType;
import org.apache.commons.lang3.StringUtils;

public class MetadataCacheUtils {
    private static String dataAnnotation = "@date";

    private MetadataCacheUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getTypeName(int typeNum) {
        if (typeNum == DOCleverItemType.STRING.getKey()) {
            return DOCleverItemType.STRING.getName();
        }
        if (typeNum == DOCleverItemType.NUMBER.getKey()) {
            return DOCleverItemType.NUMBER.getName();
        }
        if (typeNum == DOCleverItemType.BOOLEAN.getKey()) {
            return DOCleverItemType.BOOLEAN.getName();
        }
        if (typeNum == DOCleverItemType.ARRAY.getKey()) {
            return DOCleverItemType.ARRAY.getName();
        }
        if (typeNum == DOCleverItemType.OBJECT.getKey()) {
            return DOCleverItemType.OBJECT.getName();
        }
        if (typeNum == DOCleverItemType.DATE.getKey()) {
            return DOCleverItemType.DATE.getName();
        }
        return "";
    }

    public static boolean isArray(int typeNum) {
        return StringUtils.equals((CharSequence)DOCleverItemType.ARRAY.getName(), (CharSequence)MetadataCacheUtils.getTypeName(typeNum));
    }

    public static boolean isObject(int typeNum) {
        return StringUtils.equals((CharSequence)DOCleverItemType.OBJECT.getName(), (CharSequence)MetadataCacheUtils.getTypeName(typeNum));
    }

    public static String createAPIName(String url, String method) {
        return StringUtils.replaceAll((String)url, (String)"/", (String)".") + "." + method;
    }

    public static boolean isDateType(MCText description) {
        if (description == null) {
            return false;
        }
        String descriptionCN = description.getZh_CN();
        String descriptionTW = description.getZh_TW();
        return StringUtils.contains((CharSequence)descriptionCN, (CharSequence)dataAnnotation) || StringUtils.contains((CharSequence)descriptionTW, (CharSequence)dataAnnotation);
    }
}

