/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.registry.configuration;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.registry.DOCleverDataSource;
import com.digiwin.app.registry.MetadataCacheUpdater;
import com.digiwin.app.registry.data.MCAPIInfoDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class DWServiceAutoRegistration {
    private static Log log = LogFactory.getLog(DWServiceAutoRegistration.class);
    private NamingMaintainService namingMaintainService;
    private NamingService namingService;
    private DOCleverDataSource docleverDataSource;
    private MetadataCacheUpdater metadataCacheUpdater;
    private String appId;

    public DWServiceAutoRegistration() throws DWException {
        this.init();
    }

    private void init() throws DWException {
        this.appId = DWApplicationConfigUtils.getProperty((String)"appId");
        this.docleverDataSource = new DOCleverDataSource();
        this.metadataCacheUpdater = new MetadataCacheUpdater();
        int updatedRecords = this.updateMetadataCache();
        log.info((Object)("Metadata Cache is updated, " + updatedRecords + " services are updated."));
    }

    private int updateMetadataCache() {
        int result = 0;
        for (Map.Entry<String, MCAPIInfoDTO> entry : this.docleverDataSource.getApiNameMap().entrySet()) {
            MCAPIInfoDTO dto = entry.getValue();
            String apiMetadata = this.docleverDataSource.getAPIItems(dto.getApiName());
            log.info((Object)apiMetadata);
            this.updateMetadata(apiMetadata);
            ++result;
        }
        return result;
    }

    private void removeAllServices() throws NacosException {
        List serviceNames = this.namingService.getServicesOfServer(1, Integer.MAX_VALUE, this.appId).getData();
        for (String serviceName : serviceNames) {
            this.namingMaintainService.deleteService(serviceName, this.appId);
        }
    }

    private void register() {
        for (Map.Entry<String, MCAPIInfoDTO> entry : this.docleverDataSource.getApiNameMap().entrySet()) {
            MCAPIInfoDTO dto = entry.getValue();
            Service service = new Service();
            service.setName(dto.getApiName());
            service.setGroupName(this.appId);
            service.setProtectThreshold(0.0f);
            HashMap<String, String> metadata = new HashMap<String, String>();
            String apiMetadata = this.docleverDataSource.getAPIItems(dto.getApiName());
            this.updateMetadata(apiMetadata);
            metadata.put("metadataCache", apiMetadata);
            service.setMetadata(metadata);
            this.createService(service);
        }
    }

    private void updateMetadata(String apiMetadata) {
        String result = this.metadataCacheUpdater.updateAPIMetadata(apiMetadata);
        JSONObject resultJSON = new JSONObject(result);
        String code = resultJSON.getJSONObject("execution").getString("code");
        JSONObject apiMetadataJSON = new JSONObject(apiMetadata);
        if (StringUtils.equals((CharSequence)code, (CharSequence)"000")) {
            log.info((Object)("API: " + apiMetadataJSON.getString("api_name") + ", updated metadata cache successfully"));
        } else {
            log.error((Object)("API: " + apiMetadataJSON.getString("api_name") + ", failed to update metadata cache"));
            log.error((Object)("Fail code:" + code + ", the fail reason: " + resultJSON.getJSONObject("execution").getString("description")));
        }
    }

    private void createService(Service service) {
        try {
            this.namingMaintainService.createService(service, (AbstractSelector)new NoneSelector());
            log.info((Object)("nacos service, " + service.getName() + " register finished"));
        }
        catch (Exception e) {
            log.error((Object)("nacos registry," + service.getName() + " register failed...,"), (Throwable)e);
        }
    }
}

