/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.registry;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.registry.DOCleverService;
import com.digiwin.app.registry.IDOCleverService;
import com.digiwin.app.registry.MetadataCacheConverter;
import com.digiwin.app.registry.data.DCVersionAPIDTO;
import com.digiwin.app.registry.data.MCAPIInfoDTO;
import com.digiwin.app.registry.data.MCAPIMetadata;
import com.digiwin.app.registry.enumeration.DOCleverItemParam;
import com.digiwin.app.registry.utils.MetadataCacheUtils;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class DOCleverDataSource {
    private static Log log = LogFactory.getLog(DOCleverDataSource.class);
    IDOCleverService docleverService;
    MetadataCacheConverter metadataCacheConverter;
    Gson gson;
    private String teamId = "";
    private String projectId = "";
    private Map<String, List<DCVersionAPIDTO>> apiVersionMap;
    private Map<String, MCAPIInfoDTO> apiNameMap = new HashMap<String, MCAPIInfoDTO>();

    public DOCleverDataSource() throws DWException {
        this.init();
    }

    private void init() throws DWException {
        this.docleverService = new DOCleverService();
        this.metadataCacheConverter = new MetadataCacheConverter();
        this.teamId = DWApplicationConfigUtils.getProperty((String)"service.registry.teamId");
        this.projectId = DWApplicationConfigUtils.getProperty((String)"service.registry.projectId");
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        this.apiVersionMap = this.createApiNameVersionMap();
        this.apiNameMap = this.createDistinctAPINameMap();
    }

    public Map<String, MCAPIInfoDTO> getApiNameMap() {
        return this.apiNameMap;
    }

    public String getAPIItems(String apiName) {
        String result = "";
        JSONArray projectList = this.getProjectList();
        if (this.existProject(projectList)) {
            MCAPIMetadata apiMetadata = this.createMCAPIMetadataMap().get(apiName);
            result = this.toJson(apiMetadata);
        }
        return result;
    }

    private String toJson(Object source) {
        if (source == null) {
            return "";
        }
        return this.gson.toJson(source);
    }

    private Map<String, MCAPIMetadata> createMCAPIMetadataMap() {
        HashMap<String, MCAPIMetadata> result = new HashMap<String, MCAPIMetadata>();
        for (Map.Entry<String, List<DCVersionAPIDTO>> entry : this.apiVersionMap.entrySet()) {
            List<DCVersionAPIDTO> versionList = entry.getValue();
            for (DCVersionAPIDTO versionAPIDTO : versionList) {
                JSONObject apiItemInfo = this.getAPIItemInfo(versionAPIDTO.getApiId(), versionAPIDTO.getVersionId());
                String apiName = MetadataCacheUtils.createAPIName(apiItemInfo.getString(DOCleverItemParam.URL.keyName()), apiItemInfo.getString(DOCleverItemParam.METHOD.keyName()));
                MCAPIMetadata mcAPIMetadata = this.metadataCacheConverter.createAPIMetadata(result, apiItemInfo, versionAPIDTO);
                result.put(apiName, mcAPIMetadata);
            }
        }
        return result;
    }

    private Map<String, List<DCVersionAPIDTO>> createApiNameVersionMap() throws DWException {
        HashMap<String, List<DCVersionAPIDTO>> result = new HashMap<String, List<DCVersionAPIDTO>>();
        JSONArray versionList = this.getVersionList();
        for (Object versionObject : versionList) {
            JSONObject versionJSON = (JSONObject)versionObject;
            String versionId = versionJSON.getString("_id");
            String versionName = versionJSON.getString("version");
            JSONArray apiList = this.getAPIList(versionId);
            for (Object groupObject : apiList) {
                JSONObject groupJSON = (JSONObject)groupObject;
                for (Object apiObject : groupJSON.getJSONArray("data")) {
                    JSONObject apiJSON = (JSONObject)apiObject;
                    String apiId = apiJSON.getString("_id");
                    String apiName = MetadataCacheUtils.createAPIName(apiJSON.getString(DOCleverItemParam.URL.keyName()), apiJSON.getString(DOCleverItemParam.METHOD.keyName()));
                    DCVersionAPIDTO versionAPIDTO = new DCVersionAPIDTO(versionId, apiId);
                    versionAPIDTO.setApiName(apiName);
                    versionAPIDTO.setMethod(apiJSON.getString(DOCleverItemParam.METHOD.keyName()));
                    versionAPIDTO.setUrl(apiJSON.getString(DOCleverItemParam.URL.keyName()));
                    versionAPIDTO.setVersionName(versionName);
                    ArrayList<DCVersionAPIDTO> versionAPIList = (ArrayList<DCVersionAPIDTO>)result.get(apiName);
                    if (versionAPIList == null) {
                        versionAPIList = new ArrayList<DCVersionAPIDTO>();
                    }
                    versionAPIList.add(versionAPIDTO);
                    result.put(apiName, versionAPIList);
                }
            }
        }
        return result;
    }

    private JSONArray getProjectList() {
        JSONObject projectResponseJSON = new JSONObject(this.docleverService.getProjectList(this.teamId));
        return projectResponseJSON.getJSONArray("data");
    }

    private boolean existProject(JSONArray projects) {
        for (Object project : projects) {
            JSONObject projectJSON = (JSONObject)project;
            if (!StringUtils.equals((CharSequence)projectJSON.getString("_id"), (CharSequence)this.projectId)) continue;
            return true;
        }
        return false;
    }

    private JSONArray getAPIList(String versionId) {
        JSONObject allAPIResponseJSON = new JSONObject(this.docleverService.getAllAPIList(this.projectId, versionId));
        return allAPIResponseJSON.getJSONObject("data").getJSONArray("data");
    }

    private JSONArray getVersionList() throws DWException {
        int page = 0;
        JSONArray result = new JSONArray();
        JSONObject versionsResponseJSON = null;
        boolean isVersionListEmpty = true;
        do {
            versionsResponseJSON = new JSONObject(this.docleverService.getVersionList(this.projectId, page));
            if (page == 0 && versionsResponseJSON.getJSONArray("data").length() == 0) {
                log.error((Object)("project ID: " + this.projectId + ", \u7121\u7248\u672c\u4fe1\u606f"));
                throw new DWException("project ID: " + this.projectId + ", \u7121\u7248\u672c\u4fe1\u606f");
            }
            JSONArray versionArray = versionsResponseJSON.getJSONArray("data");
            if (versionArray.length() > 0) {
                result.put((Object)versionsResponseJSON.getJSONArray("data"));
                isVersionListEmpty = false;
            } else {
                isVersionListEmpty = true;
            }
            ++page;
        } while (!isVersionListEmpty);
        return result.getJSONArray(0);
    }

    private JSONObject getAPIItemInfo(String serviceId, String versionId) {
        JSONObject versionsResponseJSON = new JSONObject(this.docleverService.getAPIItemInfo(serviceId, versionId));
        return versionsResponseJSON.getJSONObject("data");
    }

    private Map<String, MCAPIInfoDTO> createDistinctAPINameMap() throws DWException {
        JSONArray versionList = this.getVersionList();
        HashMap<String, MCAPIInfoDTO> result = new HashMap<String, MCAPIInfoDTO>();
        for (Object versionObject : versionList) {
            JSONObject versionJSON = (JSONObject)versionObject;
            String versionId = versionJSON.getString("_id");
            JSONArray apiList = this.getAPIList(versionId);
            for (Object groupObject : apiList) {
                JSONObject groupJSON = (JSONObject)groupObject;
                for (Object apiObject : groupJSON.getJSONArray("data")) {
                    JSONObject apiJSON = (JSONObject)apiObject;
                    String apiName = MetadataCacheUtils.createAPIName(apiJSON.getString(DOCleverItemParam.URL.keyName()), apiJSON.getString(DOCleverItemParam.METHOD.keyName()));
                    MCAPIInfoDTO dto = new MCAPIInfoDTO();
                    dto.setApiName(apiName);
                    dto.setUrl(apiJSON.getString(DOCleverItemParam.URL.keyName()));
                    dto.setMethod(apiJSON.getString(DOCleverItemParam.METHOD.keyName()));
                    result.put(apiName, dto);
                }
            }
        }
        return result;
    }
}

