/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.registry.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static Log log = LogFactory.getLog(HttpClientUtils.class);
    public static final String ERROR_MESSEGE_CLIENT_CLOSE = "httpClient close failed: ";

    private HttpClientUtils() {
        throw new IllegalStateException("Utility class is not allowed to instantial");
    }

    public static String doGet(String url, String cookie) {
        HttpGet httpGet = new HttpGet(url);
        if (StringUtils.isNotBlank((CharSequence)cookie)) {
            httpGet.setHeader("Cookie", cookie);
        }
        return HttpClientUtils.doGetCore((HttpUriRequest)httpGet);
    }

    public static String doGet(String url, Header[] headers) {
        HttpGet httpGet = new HttpGet(url);
        if (headers != null) {
            for (Header header : headers) {
                httpGet.addHeader(header);
            }
        }
        return HttpClientUtils.doGetCore((HttpUriRequest)httpGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doGetCore(HttpUriRequest httpGet) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = builder.build();
        try {
            HttpEntity entity;
            CloseableHttpResponse response = httpClient.execute(httpGet);
            if (response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null) {
                String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
        }
        catch (IOException e) {
            log.error((Object)"HTTP doGetCore problem: ", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error((Object)ERROR_MESSEGE_CLIENT_CLOSE, (Throwable)e);
            }
        }
        return "{}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map params) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
        JSONObject parameters = new JSONObject(params);
        String jsonString = parameters.toJSONString();
        StringEntity stringEntity = new StringEntity(jsonString, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        String result = "{}";
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = builder.build();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            result = HttpClientUtils.getResponseContent(response);
        }
        catch (IOException e) {
            log.error((Object)"HTTP doPost problem: ", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error((Object)ERROR_MESSEGE_CLIENT_CLOSE, (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postWithForm(String url, Map<String, String> params) {
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            form.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, Consts.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        String result = "{}";
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = builder.build();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String string = HttpClientUtils.getResponseContent(response);
            return string;
        }
        catch (IOException e) {
            log.error((Object)"HTTP postWithForm problem: ", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error((Object)ERROR_MESSEGE_CLIENT_CLOSE, (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postWithBody(String url, String body) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
        StringEntity stringEntity = new StringEntity(body, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        String result = "{}";
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = builder.build();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            result = HttpClientUtils.getResponseContent(response);
        }
        catch (IOException e) {
            log.error((Object)"HTTP doPost problem: ", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error((Object)ERROR_MESSEGE_CLIENT_CLOSE, (Throwable)e);
            }
        }
        return result;
    }

    private static String getResponseContent(CloseableHttpResponse response) {
        String result = "{}";
        try {
            InputStream content = response.getEntity().getContent();
            if (content == null) {
                return result;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(content, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder("");
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            result = stringBuilder.toString();
        }
        catch (IOException e) {
            log.error((Object)"HTTP getResponseContent problem: ", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getHeader(String url, Map<String, Object> params, String headerName) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
        JSONObject parameters = new JSONObject(params);
        String jsonString = parameters.toJSONString();
        StringEntity stringEntity = new StringEntity(jsonString, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        String result = "";
        HttpClientBuilder builder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = builder.build();
        try {
            String string;
            Throwable throwable;
            CloseableHttpResponse response;
            block23: {
                block24: {
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    throwable = null;
                    string = response.getFirstHeader(headerName).getValue();
                    if (response == null) break block23;
                    if (throwable == null) break block24;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block23;
                }
                response.close();
            }
            return string;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (response != null) {
                            if (throwable != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                response.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    log.error((Object)"HTTP getHeader problem: ", (Throwable)e);
                }
            }
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error((Object)ERROR_MESSEGE_CLIENT_CLOSE, (Throwable)e);
            }
        }
        return result;
    }
}

