/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.registry;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.registry.data.DCVersionAPIDTO;
import com.digiwin.app.registry.data.MCAPIMetadata;
import com.digiwin.app.registry.data.MCAppVersionInfo;
import com.digiwin.app.registry.data.MCBody;
import com.digiwin.app.registry.data.MCDataMetadata;
import com.digiwin.app.registry.data.MCHeader;
import com.digiwin.app.registry.data.MCQueryParam;
import com.digiwin.app.registry.data.MCRequest;
import com.digiwin.app.registry.data.MCResponse;
import com.digiwin.app.registry.data.MCText;
import com.digiwin.app.registry.enumeration.DOCleverItemParam;
import com.digiwin.app.registry.enumeration.DOCleverItemType;
import com.digiwin.app.registry.utils.MetadataCacheUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetadataCacheConverter {
    public MCAPIMetadata createAPIMetadata(Map<String, MCAPIMetadata> apiMetadataMap, JSONObject apiItemData, DCVersionAPIDTO versionAPIDTO) {
        MCAPIMetadata mcAPIMetadata = new MCAPIMetadata();
        String apiName = MetadataCacheUtils.createAPIName(apiItemData.getString(DOCleverItemParam.NAME.keyName()));
        mcAPIMetadata.setApiName(apiName);
        mcAPIMetadata.setAppName(apiItemData.getJSONObject(DOCleverItemParam.PROJECT.keyName()).getString(DOCleverItemParam.NAME.keyName()));
        mcAPIMetadata.setMethod(apiItemData.getString(DOCleverItemParam.METHOD.keyName()));
        String localHost = DWApplicationConfigUtils.getProperty((String)"local.host");
        mcAPIMetadata.setUrl(localHost + apiItemData.getString(DOCleverItemParam.URL.keyName()));
        mcAPIMetadata.setCategory(apiItemData.getJSONObject(DOCleverItemParam.GROUP.keyName()).getString(DOCleverItemParam.NAME.keyName()));
        MCText description = new MCText();
        description.setZh_CN(apiItemData.getString(DOCleverItemParam.NAME.keyName()));
        description.setZh_TW(apiItemData.getString(DOCleverItemParam.NAME.keyName()));
        description.setEn(apiItemData.getString(DOCleverItemParam.NAME.keyName()));
        mcAPIMetadata.setDescription(description);
        MCText remark = new MCText();
        remark.setZh_CN(apiItemData.getString(DOCleverItemParam.REMARK.keyName()));
        remark.setZh_TW(apiItemData.getString(DOCleverItemParam.REMARK.keyName()));
        remark.setEn(apiItemData.getString(DOCleverItemParam.REMARK.keyName()));
        mcAPIMetadata.setRemark(remark);
        MCAppVersionInfo mcAppVersionInfo = new MCAppVersionInfo(versionAPIDTO.getVersionName());
        mcAppVersionInfo.setDataMetadata(this.createDataMetadata(apiItemData));
        ArrayList<MCAppVersionInfo> appVersionInfo = new ArrayList<MCAppVersionInfo>();
        if (apiMetadataMap.containsKey(apiName)) {
            appVersionInfo = apiMetadataMap.get(apiName).getAppVersionInfo();
        }
        appVersionInfo.add(mcAppVersionInfo);
        mcAPIMetadata.setAppVersionInfo(appVersionInfo);
        return mcAPIMetadata;
    }

    private MCDataMetadata createDataMetadata(JSONObject apiItemData) {
        MCResponse responseSuccess = this.createResponse();
        MCResponse responseFailed = this.createResponse();
        MCRequest request = this.createRequest();
        if (this.existParam(apiItemData)) {
            this.setRequest(request, apiItemData);
            this.setResponseSuccess(responseSuccess, apiItemData);
            this.setResponseFailed(responseFailed, apiItemData);
        }
        return new MCDataMetadata(request, responseSuccess, responseFailed);
    }

    private MCRequest createRequest() {
        MCRequest request = new MCRequest();
        request.setHeader(new ArrayList<MCHeader>());
        request.setQueryParam(new ArrayList<MCQueryParam>());
        request.setBody(new ArrayList<MCBody>());
        return request;
    }

    private MCResponse createResponse() {
        MCResponse response = new MCResponse();
        response.setHeader(new ArrayList<MCHeader>());
        response.setBody(new ArrayList<MCBody>());
        return response;
    }

    private void setRequest(MCRequest request, JSONObject apiItemData) {
        List<MCBody> mcBodys = request.getBody();
        JSONObject apiParamJSON = apiItemData.getJSONArray(DOCleverItemParam.PARAM.keyName()).getJSONObject(0);
        this.setHeaders(request.getHeader(), apiParamJSON.getJSONArray(DOCleverItemParam.HEADER.keyName()));
        this.setQueryParams(request.getQueryParam(), apiParamJSON.getJSONArray(DOCleverItemParam.QUERY_PARAM.keyName()));
        if (apiParamJSON.isNull(DOCleverItemParam.BODY_INFO.keyName())) {
            return;
        }
        JSONArray bodys = apiParamJSON.getJSONObject(DOCleverItemParam.BODY_INFO.keyName()).getJSONArray(DOCleverItemParam.RAW_JSON.keyName());
        for (int i = 0; i < bodys.length(); ++i) {
            mcBodys.add(this.setBody((JSONObject)bodys.get(i)));
        }
    }

    private void setQueryParams(List<MCQueryParam> mcQueryParams, JSONArray queryParams) {
        for (Object queryParamObject : queryParams) {
            JSONObject queryParamJSON = (JSONObject)queryParamObject;
            MCText queryParamRemark = new MCText();
            queryParamRemark.setZh_CN(queryParamJSON.getString(DOCleverItemParam.REMARK.keyName()));
            queryParamRemark.setZh_TW(queryParamJSON.getString(DOCleverItemParam.REMARK.keyName()));
            queryParamRemark.setEn(queryParamJSON.getString(DOCleverItemParam.REMARK.keyName()));
            MCQueryParam queryParam = new MCQueryParam(queryParamJSON.getString(DOCleverItemParam.NAME.keyName()), true, queryParamRemark);
            mcQueryParams.add(queryParam);
        }
    }

    private MCBody setBody(JSONObject bodyJSON) {
        MCBody result = this.createBody(bodyJSON);
        if (!bodyJSON.isNull(DOCleverItemParam.DATA.keyName())) {
            JSONArray bodyArray = bodyJSON.getJSONArray(DOCleverItemParam.DATA.keyName());
            if (MetadataCacheUtils.isArray(bodyJSON.getInt(DOCleverItemParam.TYPE.keyName()))) {
                JSONObject subBody = bodyArray.getJSONObject(0);
                if (MetadataCacheUtils.isObject(subBody.getInt(DOCleverItemParam.TYPE.keyName()))) {
                    result.setField(new ArrayList<MCBody>());
                    result.setDataType(DOCleverItemType.OBJECT.getName());
                    for (Object object : subBody.getJSONArray(DOCleverItemParam.DATA.keyName())) {
                        result.getField().add(this.setBody((JSONObject)object));
                    }
                } else {
                    result.setDataType(MetadataCacheUtils.getTypeName(subBody.getInt(DOCleverItemParam.TYPE.keyName())));
                }
                result.setIsArray(true);
            } else {
                result.setField(new ArrayList<MCBody>());
                for (Object object : bodyArray) {
                    result.getField().add(this.setBody((JSONObject)object));
                }
            }
        }
        return result;
    }

    private MCBody createBody(JSONObject bodyJSON) {
        String remark = bodyJSON.getString(DOCleverItemParam.REMARK.keyName());
        if (MetadataCacheUtils.isBussinessKey(remark)) {
            // empty if block
        }
        MCText descriptionText = new MCText();
        descriptionText.setZh_CN(remark);
        descriptionText.setZh_TW(remark);
        descriptionText.setEn(remark);
        String mock = bodyJSON.getString(DOCleverItemParam.MOCK.keyName());
        MCText remarkText = new MCText();
        remarkText.setZh_CN(mock);
        remarkText.setZh_TW(mock);
        remarkText.setEn(mock);
        MCBody result = new MCBody(bodyJSON.getString(DOCleverItemParam.NAME.keyName()), MetadataCacheUtils.getTypeName(bodyJSON.getInt(DOCleverItemParam.TYPE.keyName())), bodyJSON.getInt(DOCleverItemParam.MUST.keyName()) == 1);
        result.setDescription(descriptionText);
        result.setRemark(remarkText);
        if (MetadataCacheUtils.isDateType(remark)) {
            result.setDataType(DOCleverItemType.DATE.getName());
            MetadataCacheUtils.setDateFormat(remarkText, remark);
        }
        result.setIsBusinesskey(MetadataCacheUtils.isBussinessKey(remark));
        return result;
    }

    private void setResponseSuccess(MCResponse response, JSONObject apiItemData) {
        List<MCBody> mcBodys = response.getBody();
        JSONObject apiParamJSON = apiItemData.getJSONArray(DOCleverItemParam.PARAM.keyName()).getJSONObject(0);
        this.setResponseHeader(response, apiItemData);
        if (apiParamJSON.isNull(DOCleverItemParam.OUT_PARAM.keyName())) {
            return;
        }
        JSONArray responses = apiItemData.getJSONArray(DOCleverItemParam.PARAM.keyName()).getJSONObject(0).getJSONArray(DOCleverItemParam.OUT_PARAM.keyName());
        for (int i = 0; i < responses.length(); ++i) {
            mcBodys.add(this.setBody((JSONObject)responses.get(i)));
        }
    }

    private void setResponseFailed(MCResponse response, JSONObject apiItemData) {
        List<MCBody> mcBodys = response.getBody();
        JSONObject apiParamJSON = apiItemData.getJSONArray(DOCleverItemParam.PARAM.keyName()).getJSONObject(1);
        this.setResponseHeader(response, apiItemData);
        if (apiParamJSON.isNull(DOCleverItemParam.OUT_PARAM.keyName())) {
            return;
        }
        JSONArray responseBody = apiItemData.getJSONArray(DOCleverItemParam.PARAM.keyName()).getJSONObject(0).getJSONArray(DOCleverItemParam.OUT_PARAM.keyName());
        for (int i = 0; i < responseBody.length(); ++i) {
            mcBodys.add(this.setBody((JSONObject)responseBody.get(i)));
        }
    }

    private void setResponseHeader(MCResponse response, JSONObject apiItemData) {
        JSONObject apiParamJSON = apiItemData.getJSONArray(DOCleverItemParam.PARAM.keyName()).getJSONObject(1);
        this.setHeaders(response.getHeader(), apiParamJSON.getJSONArray(DOCleverItemParam.HEADER.keyName()));
    }

    private boolean existParam(JSONObject apiItemData) {
        return !apiItemData.getJSONArray(DOCleverItemParam.PARAM.keyName()).isNull(0) && !apiItemData.getJSONArray(DOCleverItemParam.PARAM.keyName()).isNull(1);
    }

    private void setHeaders(List<MCHeader> mcHeaders, JSONArray headers) {
        for (Object headerObject : headers) {
            JSONObject headerJSON = (JSONObject)headerObject;
            MCText descriptionText = new MCText();
            descriptionText.setZh_CN(headerJSON.getString(DOCleverItemParam.REMARK.keyName()));
            descriptionText.setZh_TW(headerJSON.getString(DOCleverItemParam.REMARK.keyName()));
            descriptionText.setEn(headerJSON.getString(DOCleverItemParam.REMARK.keyName()));
            MCHeader header = new MCHeader(headerJSON.getString(DOCleverItemParam.NAME.keyName()), true, descriptionText);
            mcHeaders.add(header);
        }
    }
}

