/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.registry;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.registry.IDOCleverService;
import com.digiwin.app.registry.utils.HttpClientUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.json.JSONObject;

public class DOCleverService
implements IDOCleverService {
    private static final String HTTP = "http://";
    private String serverAddress = DWApplicationConfigUtils.getProperty((String)"service.registry.doclever.serverAddress");
    private static final String URL_PROJECT_LIST = "/team/projectlist";
    private static final String URL_ALL_API_LIST = "/project/interface";
    private static final String URL_VERSION_LIST = "/version/list";
    private static final String URL_API_ITEM = "/interface/item";
    private static final String URL_LOGIN = "/user/login";
    private static final String HEADER_KEY_DOCLEVER_VERSION = "docleverversion";
    private String cookie = "";

    public DOCleverService() {
        this.initCookie();
    }

    private void initCookie() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", DWApplicationConfigUtils.getProperty((String)"service.registry.login.name"));
        params.put("password", DWApplicationConfigUtils.getProperty((String)"service.registry.login.password"));
        String responseCookie = HttpClientUtils.getHeader(HTTP + this.serverAddress + URL_LOGIN, params, "set-cookie");
        String responseBody = HttpClientUtils.doPost(HTTP + this.serverAddress + URL_LOGIN, params);
        JSONObject bodyJSONObject = new JSONObject(responseBody);
        String userId = bodyJSONObject.getJSONObject("data").getString("_id");
        String sid = StringUtils.substringBetween((String)responseCookie, (String)"connect.sid=", (String)";");
        this.cookie = "connect.sid=" + sid + "; id=" + userId;
    }

    @Override
    public String getProjectList(String teamId) {
        String url = HTTP + this.serverAddress + URL_PROJECT_LIST + "?id=" + teamId;
        return HttpClientUtils.doGet(url, this.cookie);
    }

    @Override
    public String getAllAPIList(String projectId) {
        String url = HTTP + this.serverAddress + URL_ALL_API_LIST + "?id=" + projectId + "&page=0";
        return HttpClientUtils.doGet(url, this.cookie);
    }

    @Override
    public String getAllAPIList(String projectId, String versionId) {
        String url = HTTP + this.serverAddress + URL_ALL_API_LIST + "?id=" + projectId + "&type=0";
        BasicHeader[] headers = new BasicHeader[]{new BasicHeader("Cookie", this.cookie), new BasicHeader(HEADER_KEY_DOCLEVER_VERSION, versionId)};
        return HttpClientUtils.doGet(url, (Header[])headers);
    }

    @Override
    public String getVersionList(String projectId, int page) {
        String url = HTTP + this.serverAddress + URL_VERSION_LIST + "?project=" + projectId + "&page=" + page;
        return HttpClientUtils.doGet(url, this.cookie);
    }

    @Override
    public String getAPIItemInfo(String serviceId) {
        String url = HTTP + this.serverAddress + URL_API_ITEM + "?id=" + serviceId;
        return HttpClientUtils.doGet(url, this.cookie);
    }

    @Override
    public String getAPIItemInfo(String serviceId, String versionId) {
        String url = HTTP + this.serverAddress + URL_API_ITEM + "?id=" + serviceId;
        BasicHeader[] headers = new BasicHeader[]{new BasicHeader("Cookie", this.cookie), new BasicHeader(HEADER_KEY_DOCLEVER_VERSION, versionId)};
        return HttpClientUtils.doGet(url, (Header[])headers);
    }
}

