/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.restful;

import com.digiwin.app.container.DWAbstractHeaderRepository;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWRestfulHeader;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.restful.DWRestfulRequestInfo;
import com.digiwin.app.container.restful.UrlNode;
import com.digiwin.app.container.restful.UrlParser;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulServiceLocationInfo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWRestfulHeaderRepository
extends DWAbstractHeaderRepository<DWRestfulHeader, DWRestfulServiceLocationInfo> {
    private Map<String, Map<DWRequestMethod, UrlNode>> _restfulMethodMap = new HashMap<String, Map<DWRequestMethod, UrlNode>>();

    protected void afterRegister(String groupName, List<DWRestfulHeader> headers, List<DWRestfulHeader> oldHeaders) {
        headers.forEach(h -> log.info((Object)("  |_____" + h.getServiceType().getName())));
        this._restfulMethodMap.remove(groupName);
        for (DWHeader dWHeader : headers) {
            Method[] methods;
            Map<Object, Object> url;
            if (this._restfulMethodMap.containsKey(groupName)) {
                url = this._restfulMethodMap.get(groupName);
            } else {
                url = new HashMap<DWRequestMethod, UrlNode>();
                url.put(DWRequestMethod.GET, new UrlNode("getRoot"));
                url.put(DWRequestMethod.HEAD, new UrlNode("headRoot"));
                url.put(DWRequestMethod.POST, new UrlNode("postRoot"));
                url.put(DWRequestMethod.PUT, new UrlNode("putRoot"));
                url.put(DWRequestMethod.PATCH, new UrlNode("patchRoot"));
                url.put(DWRequestMethod.DELETE, new UrlNode("deleteRoot"));
                url.put(DWRequestMethod.OPTIONS, new UrlNode("optionsRoot"));
                url.put(DWRequestMethod.TRACE, new UrlNode("traceRoot"));
            }
            Class interfaceType = dWHeader.getServiceType();
            for (Method method : methods = interfaceType.getMethods()) {
                if (!method.isAnnotationPresent(DWRequestMapping.class)) continue;
                DWRequestMapping requestMapping = method.getAnnotation(DWRequestMapping.class);
                String path = requestMapping.path();
                for (DWRequestMethod httpMethod : requestMapping.method()) {
                    UrlNode urlNode = (UrlNode)url.get(httpMethod);
                    urlNode.addUrl(path, new DWMethod(method));
                    url.put(httpMethod, urlNode);
                }
            }
            this._restfulMethodMap.put(groupName, url);
        }
    }

    protected DWTargetAPI searchAPI(DWRestfulServiceLocationInfo locationInfo) {
        DWMethod method = this.getDWRestfulMethod(locationInfo.getGroup(), locationInfo.getRequest(), locationInfo.getMethod());
        if (method == null) {
            return DWTargetAPI.createInvalidAPI();
        }
        DWRestfulHeader header = this.getRestfulHeader(locationInfo.getGroup(), method);
        return new DWTargetAPI((DWHeader)header, method);
    }

    public DWMethod getDWRestfulMethod(String groupName, DWRestfulRequestInfo request, DWRequestMethod httpMethod) {
        if (!this._restfulMethodMap.containsKey(groupName)) {
            return null;
        }
        Map<DWRequestMethod, UrlNode> urlNodeMap = this._restfulMethodMap.get(groupName);
        UrlNode urlNode = urlNodeMap.get(httpMethod);
        UrlParser.parse((UrlNode)urlNode, (int)0, (DWRestfulRequestInfo)request);
        return request.getDWMethod();
    }

    private DWRestfulHeader getRestfulHeader(String groupName, DWMethod method) {
        List headers = (List)this._headers.get(groupName);
        Class<?> methodDeclaringClass = method.getMethod().getDeclaringClass();
        return headers.stream().filter(h -> h.getServiceType() == methodDeclaringClass).findFirst().orElse(null);
    }
}

