/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWQueryStringParameters;
import com.digiwin.app.service.DWFile;
import com.digiwin.app.service.restful.DWPathVariable;
import com.digiwin.app.service.restful.DWRequestBody;
import com.digiwin.app.service.restful.DWRequestBodyParam;
import com.digiwin.app.service.restful.DWRequestParam;
import com.digiwin.app.service.restful.DWRestfulRequest;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class DWRestfulParameters
extends DWDefaultParameters {
    private DWMethod method;
    private String body;
    private DWRestfulRequest restfulRequest;
    private DWQueryStringParameters requestParam;
    private DWDefaultParameters pathVariable;
    private DWDefaultParameters requestBody;

    public DWRestfulParameters(DWMethod method, HttpServletRequest request, DWRestfulRequest restfulRequest) {
        this.method = method;
        this.body = restfulRequest.getBodyAsString();
        this.restfulRequest = restfulRequest;
        this.initialize(request, restfulRequest.getPathVariable(), this.body);
    }

    private void initialize(HttpServletRequest request, Map<String, Object> pathVariableMap, String body) {
        this.requestParam = new DWQueryStringParameters(request);
        this.pathVariable = new DWDefaultParameters(pathVariableMap);
        Optional<String> contentTypeOptional = Optional.ofNullable(request.getContentType());
        String contentType = contentTypeOptional.orElse("").toLowerCase();
        if (contentType.toLowerCase().contains("xml")) {
            HashMap<String, String> source = new HashMap<String, String>();
            source.put("xml", body);
            this.requestBody = new DWDefaultParameters(source);
        } else {
            this.requestBody = new DWDefaultParameters(body);
        }
        super.putAll(this.pathVariable.getPararmeters());
        super.putAll(this.requestBody.getPararmeters());
        super.putAll(this.requestParam.getPararmeters());
    }

    public Object getValue(String parameterName, Class<?> parameterType) throws Exception {
        if (DWRestfulRequest.class.isAssignableFrom(parameterType)) {
            return this.restfulRequest;
        }
        Parameter[] parameters = this.method.getMethod().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (!parameter.getName().equals(parameterName)) continue;
            return this.getValue(parameter);
        }
        if (parameterType == DWFile.class) {
            return this._parameters.get(parameterName);
        }
        if (super.getPararmeters().containsKey(parameterName)) {
            return super.getValue(parameterName, parameterType);
        }
        return super.convertValueType((Object)this.body, parameterType);
    }

    public Object getValue(Parameter parameter) throws Exception {
        Class<?> parameterType = parameter.getType();
        if (DWRestfulRequest.class.isAssignableFrom(parameterType)) {
            return this.restfulRequest;
        }
        if (parameter.isAnnotationPresent(DWRequestParam.class)) {
            return this.requestParam.getValue(parameter);
        }
        if (parameter.isAnnotationPresent(DWPathVariable.class)) {
            return this.pathVariable.getValue(parameter);
        }
        if (parameter.isAnnotationPresent(DWRequestBody.class)) {
            return super.convertValueType((Object)this.body, parameterType, parameter.getParameterizedType());
        }
        if (parameter.isAnnotationPresent(DWRequestBodyParam.class)) {
            return this.requestBody.getValue(parameter);
        }
        String parameterName = parameter.getName();
        if (parameterType == DWFile.class) {
            return this._parameters.get(parameterName);
        }
        if (super.getPararmeters().containsKey(parameterName)) {
            return super.getValue(parameter);
        }
        return super.convertValueType((Object)this.body, parameterType, parameter.getParameterizedType());
    }

    public DWRestfulRequest getRestfulRequest() {
        return this.restfulRequest;
    }

    public DWMethod getMethod() {
        return this.method;
    }
}

