/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.restful;

import com.digiwin.app.container.DWAbstractHeaderRepository;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWRestfulHeader;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.restful.DWRestfulRequestInfo;
import com.digiwin.app.container.restful.UrlNode;
import com.digiwin.app.container.restful.UrlParser;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulServiceLocationInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DWRestfulHeaderRepository
extends DWAbstractHeaderRepository<DWRestfulHeader, DWRestfulServiceLocationInfo> {
    private Map<String, Map<DWRequestMethod, UrlNode>> restfulMethodMap = new HashMap<String, Map<DWRequestMethod, UrlNode>>();

    protected void afterRegister(String groupName, List<DWRestfulHeader> headers, List<DWRestfulHeader> oldHeaders) {
        headers.forEach(h -> log.info((Object)("  |___ " + h.getServiceType().getName())));
        this.restfulMethodMap.remove(groupName);
        for (DWHeader dWHeader : headers) {
            Method[] methods;
            Map<Object, Object> url;
            if (this.restfulMethodMap.containsKey(groupName)) {
                url = this.restfulMethodMap.get(groupName);
            } else {
                url = new HashMap<DWRequestMethod, UrlNode>();
                url.put(DWRequestMethod.GET, new UrlNode("getRoot"));
                url.put(DWRequestMethod.HEAD, new UrlNode("headRoot"));
                url.put(DWRequestMethod.POST, new UrlNode("postRoot"));
                url.put(DWRequestMethod.PUT, new UrlNode("putRoot"));
                url.put(DWRequestMethod.PATCH, new UrlNode("patchRoot"));
                url.put(DWRequestMethod.DELETE, new UrlNode("deleteRoot"));
                url.put(DWRequestMethod.OPTIONS, new UrlNode("optionsRoot"));
                url.put(DWRequestMethod.TRACE, new UrlNode("traceRoot"));
            }
            Class interfaceType = dWHeader.getServiceType();
            String servicePath = "";
            if (interfaceType.isAnnotationPresent(DWRequestMapping.class)) {
                DWRequestMapping typeRequestMapping = interfaceType.getAnnotation(DWRequestMapping.class);
                servicePath = typeRequestMapping.path();
            }
            for (Method method : methods = interfaceType.getMethods()) {
                if (!method.isAnnotationPresent(DWRequestMapping.class)) continue;
                DWRequestMapping requestMapping = method.getAnnotation(DWRequestMapping.class);
                String path = requestMapping.path();
                for (DWRequestMethod httpMethod : requestMapping.method()) {
                    UrlNode urlNode = (UrlNode)url.get(httpMethod);
                    urlNode.addUrl(this.concatPath(servicePath, path), new DWMethod(method));
                    url.put(httpMethod, urlNode);
                }
            }
            this.restfulMethodMap.put(groupName, url);
        }
    }

    protected DWTargetAPI searchAPI(DWRestfulServiceLocationInfo locationInfo) {
        DWMethod method = this.getDWRestfulMethod(locationInfo.getGroup(), locationInfo.getRequest(), locationInfo.getMethod());
        if (method == null) {
            return DWTargetAPI.createInvalidAPI();
        }
        DWRestfulHeader header = this.getRestfulHeader(locationInfo.getGroup(), method);
        return new DWTargetAPI((DWHeader)header, method);
    }

    public DWMethod getDWRestfulMethod(String groupName, DWRestfulRequestInfo request, DWRequestMethod httpMethod) {
        if (!this.restfulMethodMap.containsKey(groupName)) {
            return null;
        }
        Map<DWRequestMethod, UrlNode> urlNodeMap = this.restfulMethodMap.get(groupName);
        UrlNode urlNode = urlNodeMap.get(httpMethod);
        UrlParser.parse(urlNode, 0, request);
        return request.getDWMethod();
    }

    private DWRestfulHeader getRestfulHeader(String groupName, DWMethod method) {
        List headers = (List)this.headers.get(groupName);
        Class<?> methodDeclaringClass = method.getMethod().getDeclaringClass();
        return headers.stream().filter(h -> h.getServiceType() == methodDeclaringClass).findFirst().orElse(null);
    }

    private String concatPath(String path1, String path2) {
        if (path1 == null || path1.isEmpty()) {
            return path2;
        }
        if (path2 == null || path2.isEmpty()) {
            return "";
        }
        List parts = Arrays.stream(path1.split("/")).filter(part -> !part.isEmpty()).collect(Collectors.toList());
        parts.addAll(Arrays.stream(path2.split("/")).filter(part -> !part.isEmpty()).collect(Collectors.toList()));
        return String.join((CharSequence)"/", parts);
    }
}

