/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config.remote;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.group.GroupConfigFile;
import com.digiwin.apollo.group.GroupConfigService;
import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.config.ConfigType;
import com.digiwin.app.common.config.Extension;
import com.digiwin.app.common.config.ExtensionUtils;
import com.digiwin.app.common.config.reader.BaseGroupReader;
import com.digiwin.app.common.config.reader.resource.LocaleReader;
import com.digiwin.app.common.config.remote.ConfigInfo;
import com.digiwin.app.module.DWModuleClassLoader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupReader
implements BaseGroupReader {
    private static final String TAG = "[GroupReader] ";
    private static final String CANT_FIND_FORM_REMOTE = "can't find from remote - ";
    private static final String KEY_SHARE = "share.";
    private static Log log = LogFactory.getLog(GroupReader.class);

    @Override
    public String getGroupLog4j2Xml() {
        String content = this.getGroupConfigFileString("log4j2", ConfigFileFormat.XML);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)"[GroupReader] can't find from remote - log4j2");
            return null;
        }
        return content;
    }

    @Override
    public String getGroupModuleSpringXml(String xmlNameWithoutExtension) {
        String key = KEY_SHARE + xmlNameWithoutExtension;
        String content = this.getGroupConfigFileString(key, ConfigFileFormat.XML);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[GroupReader] can't find from remote - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getGroupApplicationSpringXml(String xmlNameWithoutExtension) {
        String key = xmlNameWithoutExtension;
        String content = this.getGroupConfigFileString(key, ConfigFileFormat.XML);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[GroupReader] can't find from remote - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getGroupModuleResource(String nameWithoutExtension, Extension extension) {
        ConfigFileFormat configFileFormat;
        String key = KEY_SHARE + nameWithoutExtension;
        String content = this.getGroupConfigFileString(key, configFileFormat = ExtensionUtils.toConfigFileFormat(extension));
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[GroupReader] can't find from remote - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getGroupApplicationResource(String nameWithoutExtension, Extension extension) {
        String key = nameWithoutExtension;
        ConfigFileFormat configFileFormat = ExtensionUtils.toConfigFileFormat(extension);
        String content = this.getGroupConfigFileString(key, configFileFormat);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.debug((Object)("[GroupReader] can't find from remote - " + key));
            return null;
        }
        return content;
    }

    @Override
    public Properties getGroupProperties(String path, String propertiesNameWithoutExtension) {
        ConfigInfo configInfo = ConfigInfo.get(path, propertiesNameWithoutExtension);
        return this.getGroupProperties(configInfo);
    }

    private Properties getGroupProperties(ConfigInfo configInfo) {
        String content;
        if (configInfo == null) {
            return new Properties();
        }
        ConfigType configType = configInfo.getConfigType();
        String fileNameWithoutExtension = configInfo.getFileNameWithoutExtension();
        if (ConfigType.PLATFORM.equals((Object)configType)) {
            return new Properties();
        }
        Object key = fileNameWithoutExtension;
        if (ConfigType.MODULE.equals((Object)configType)) {
            key = KEY_SHARE + fileNameWithoutExtension;
        }
        if (StringUtils.isBlank((CharSequence)(content = this.getGroupConfigFileString((String)key, ConfigFileFormat.Properties)))) {
            log.debug((Object)("[GroupReader] can't find from remote - " + (String)key));
            return new Properties();
        }
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(content));
        }
        catch (IOException e) {
            log.error((Object)("parse remote properties error, error message=" + e.getMessage()));
            return new Properties();
        }
        return properties;
    }

    @Override
    public String getGroupApplicationString(String baseName, String key, Object ... patternArguments) {
        return this.getGroupApplicationString(baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
    }

    private String getGroupApplicationString(String baseName, Locale locale, String key, Object ... patternArguments) {
        Object fileNameWithoutExtension = baseName;
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            fileNameWithoutExtension = (String)fileNameWithoutExtension + "_" + String.valueOf(locale);
        }
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigType(ConfigType.APPLICATION);
        configInfo.setFileNameWithoutExtension((String)fileNameWithoutExtension);
        configInfo.setModifiedFileName((String)fileNameWithoutExtension);
        Properties properties = this.getGroupProperties(configInfo);
        if (properties.containsKey(key)) {
            String groupApplicationString = (String)properties.get(key);
            if (patternArguments != null) {
                groupApplicationString = String.format(groupApplicationString, patternArguments);
            }
            return groupApplicationString;
        }
        log.debug((Object)("[GroupReader] can't find from remote - " + key));
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            return this.getGroupApplicationString(baseName, null, key, patternArguments);
        }
        return null;
    }

    @Override
    public String getGroupModuleString(String baseName, String key, Object ... patternArguments) {
        return this.getGroupModuleString(baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
    }

    private String getGroupModuleString(String baseName, Locale locale, String key, Object ... patternArguments) {
        Object fileNameWithoutExtension = baseName;
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            fileNameWithoutExtension = (String)fileNameWithoutExtension + "_" + String.valueOf(locale);
        }
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigType(ConfigType.MODULE);
        configInfo.setFileNameWithoutExtension((String)fileNameWithoutExtension);
        Properties properties = this.getGroupProperties(configInfo);
        if (properties.containsKey(key)) {
            String groupModuleString = (String)properties.get(key);
            if (patternArguments != null) {
                groupModuleString = String.format(groupModuleString, patternArguments);
            }
            return groupModuleString;
        }
        log.debug((Object)("[GroupReader] can't find from remote - " + key));
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            return this.getGroupModuleString(baseName, null, key, patternArguments);
        }
        return null;
    }

    @Override
    public String getGroupString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
        if (cl.equals(DWApplicationClassLoader.getInstance().getDWPlatformClassLoader())) {
            return null;
        }
        if (cl.equals((Object)DWApplicationClassLoader.getInstance())) {
            return this.getGroupApplicationString(baseName, locale, key, patternArguments);
        }
        String moduleName = DWModuleClassLoader.getModuleName(cl);
        return this.getGroupModuleString(moduleName, baseName, locale, key, patternArguments);
    }

    private String getGroupConfigFileString(String nameWithoutExtension, ConfigFileFormat configFileFormat) {
        GroupConfigFile groupConfigFile = GroupConfigService.getConfigFile((String)nameWithoutExtension, (ConfigFileFormat)configFileFormat);
        return groupConfigFile.getContent();
    }
}

