/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.core;

import com.ctrip.replica.apollo.core.enums.Env;
import com.ctrip.replica.apollo.core.internals.LegacyMetaServerProvider;
import com.ctrip.replica.apollo.core.spi.MetaServerProvider;
import com.ctrip.replica.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.replica.apollo.core.utils.NetUtil;
import com.ctrip.replica.apollo.internals.DefaultMetaServerProvider;
import com.ctrip.replica.apollo.tracer.Tracer;
import com.ctrip.replica.apollo.tracer.spi.Transaction;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class MetaDomainConsts {
    public static final String DEFAULT_META_URL = "http://apollo.meta";
    private static final Map<Env, String> metaServerAddressCache = Maps.newConcurrentMap();
    private static volatile List<MetaServerProvider> metaServerProviders = null;
    private static final long REFRESH_INTERVAL_IN_SECOND = 60L;
    private static final Map<String, String> selectedMetaServerAddressCache = Maps.newConcurrentMap();
    private static final AtomicBoolean periodicRefreshStarted = new AtomicBoolean(false);
    private static final Object LOCK = new Object();

    public static String getDomain(Env env) {
        String metaServerAddress = MetaDomainConsts.getMetaServerAddress(env);
        if (metaServerAddress.contains(",")) {
            return MetaDomainConsts.selectMetaServerAddress(metaServerAddress);
        }
        return metaServerAddress;
    }

    public static String getMetaServerAddress(Env env) {
        if (!metaServerAddressCache.containsKey((Object)env)) {
            MetaDomainConsts.initMetaServerAddress(env);
        }
        return metaServerAddressCache.get((Object)env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMetaServerAddress(Env env) {
        MetaServerProvider provider;
        if (metaServerProviders == null) {
            Object object = LOCK;
            synchronized (object) {
                if (metaServerProviders == null) {
                    metaServerProviders = MetaDomainConsts.initMetaServerProviders();
                }
            }
        }
        String metaAddress = null;
        Iterator<MetaServerProvider> iterator = metaServerProviders.iterator();
        while (iterator.hasNext() && Strings.isNullOrEmpty((String)(metaAddress = (provider = iterator.next()).getMetaServerAddress(env)))) {
        }
        if (Strings.isNullOrEmpty(metaAddress)) {
            metaAddress = DEFAULT_META_URL;
        }
        metaServerAddressCache.put(env, metaAddress.trim());
    }

    private static List<MetaServerProvider> initMetaServerProviders() {
        ArrayList<MetaServerProvider> metaServerProviders = new ArrayList<MetaServerProvider>();
        metaServerProviders.add(new DefaultMetaServerProvider());
        metaServerProviders.add(new LegacyMetaServerProvider());
        Collections.sort(metaServerProviders, new Comparator<MetaServerProvider>(){

            @Override
            public int compare(MetaServerProvider o1, MetaServerProvider o2) {
                return Integer.compare(o1.getOrder(), o2.getOrder());
            }
        });
        return metaServerProviders;
    }

    private static String selectMetaServerAddress(String metaServerAddresses) {
        String metaAddressSelected = selectedMetaServerAddressCache.get(metaServerAddresses);
        if (metaAddressSelected == null) {
            if (periodicRefreshStarted.compareAndSet(false, true)) {
                MetaDomainConsts.schedulePeriodicRefresh();
            }
            MetaDomainConsts.updateMetaServerAddresses(metaServerAddresses);
            metaAddressSelected = selectedMetaServerAddressCache.get(metaServerAddresses);
        }
        return metaAddressSelected;
    }

    private static void updateMetaServerAddresses(String metaServerAddresses) {
        Transaction transaction = Tracer.newTransaction("Apollo.MetaService", "refreshMetaServerAddress");
        transaction.addData("Url", metaServerAddresses);
        try {
            ArrayList metaServers = Lists.newArrayList((Object[])metaServerAddresses.split(","));
            Collections.shuffle(metaServers);
            boolean serverAvailable = false;
            for (String address : metaServers) {
                if (!NetUtil.pingUrl((address = address.trim()) + "/services/config")) continue;
                selectedMetaServerAddressCache.put(metaServerAddresses, address);
                serverAvailable = true;
                break;
            }
            if (!selectedMetaServerAddressCache.containsKey(metaServerAddresses)) {
                selectedMetaServerAddressCache.put(metaServerAddresses, ((String)metaServers.get(0)).trim());
            }
            if (!serverAvailable) {
                // empty if block
            }
            transaction.setStatus("0");
        }
        catch (Throwable ex) {
            transaction.setStatus(ex);
            throw ex;
        }
        finally {
            transaction.complete();
        }
    }

    private static void schedulePeriodicRefresh() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, ApolloThreadFactory.create("MetaServiceLocator", true));
        scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String metaServerAddresses : selectedMetaServerAddressCache.keySet()) {
                        MetaDomainConsts.updateMetaServerAddresses(metaServerAddresses);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }
}

