/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.core.utils;

import com.google.common.base.Strings;
import java.net.URL;
import java.net.URLDecoder;

public class ClassLoaderUtil {
    private static ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private static String classPath = "";

    public static ClassLoader getLoader() {
        return loader;
    }

    public static String getClassPath() {
        return classPath;
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            URL url = loader.getResource("");
            if (url != null) {
                classPath = url.getPath();
                classPath = URLDecoder.decode(classPath, "utf-8");
            }
            if (Strings.isNullOrEmpty((String)classPath) || classPath.contains(".jar!")) {
                classPath = System.getProperty("user.dir");
            }
        }
        catch (Throwable ex) {
            classPath = System.getProperty("user.dir");
        }
    }
}

