/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.util;

import com.ctrip.replica.apollo.core.MetaDomainConsts;
import com.ctrip.replica.apollo.core.enums.Env;
import com.ctrip.replica.apollo.core.enums.EnvUtils;
import com.ctrip.replica.foundation.Foundation;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class ConfigUtil {
    private int refreshInterval = 5;
    private TimeUnit refreshIntervalTimeUnit = TimeUnit.MINUTES;
    private int connectTimeout = 1000;
    private int readTimeout = 5000;
    private String cluster;
    private int loadConfigQPS = 2;
    private int longPollQPS = 2;
    private long onErrorRetryInterval = 1L;
    private TimeUnit onErrorRetryIntervalTimeUnit = TimeUnit.SECONDS;
    private long maxConfigCacheSize = 500L;
    private long configCacheExpireTime = 1L;
    private TimeUnit configCacheExpireTimeUnit = TimeUnit.MINUTES;
    private long longPollingInitialDelayInMills = 2000L;
    private boolean autoUpdateInjectedSpringProperties = true;
    private final RateLimiter warnLogRateLimiter = RateLimiter.create((double)0.017);

    public ConfigUtil() {
        this.initRefreshInterval();
        this.initConnectTimeout();
        this.initReadTimeout();
        this.initCluster();
        this.initQPS();
        this.initMaxConfigCacheSize();
        this.initLongPollingInitialDelayInMills();
        this.initAutoUpdateInjectedSpringProperties();
    }

    public String getAppId() {
        String appId = Foundation.app().getAppId();
        if (Strings.isNullOrEmpty((String)appId)) {
            appId = "ApolloNoAppIdPlaceHolder";
            if (this.warnLogRateLimiter.tryAcquire()) {
                // empty if block
            }
        }
        return appId;
    }

    public String getDataCenter() {
        return Foundation.server().getDataCenter();
    }

    private void initCluster() {
        this.cluster = System.getProperty("apollo.cluster");
        if (Strings.isNullOrEmpty((String)this.cluster)) {
            this.cluster = this.getDataCenter();
        }
        if (Strings.isNullOrEmpty((String)this.cluster)) {
            this.cluster = "default";
        }
    }

    public String getCluster() {
        String cluster = System.getProperty("platform.version");
        return cluster;
    }

    public Env getApolloEnv() {
        return EnvUtils.transformEnv(Foundation.server().getEnvType());
    }

    public String getLocalIp() {
        return Foundation.net().getHostAddress();
    }

    public String getMetaServerDomainName() {
        return MetaDomainConsts.getDomain(this.getApolloEnv());
    }

    private void initConnectTimeout() {
        String customizedConnectTimeout = System.getProperty("apollo.connectTimeout");
        if (!Strings.isNullOrEmpty((String)customizedConnectTimeout)) {
            try {
                this.connectTimeout = Integer.parseInt(customizedConnectTimeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    private void initReadTimeout() {
        String customizedReadTimeout = System.getProperty("apollo.readTimeout");
        if (!Strings.isNullOrEmpty((String)customizedReadTimeout)) {
            try {
                this.readTimeout = Integer.parseInt(customizedReadTimeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    private void initRefreshInterval() {
        String customizedRefreshInterval = System.getProperty("apollo.refreshInterval");
        if (!Strings.isNullOrEmpty((String)customizedRefreshInterval)) {
            try {
                this.refreshInterval = Integer.parseInt(customizedRefreshInterval);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public TimeUnit getRefreshIntervalTimeUnit() {
        return this.refreshIntervalTimeUnit;
    }

    private void initQPS() {
        String customizedLongPollQPS;
        String customizedLoadConfigQPS = System.getProperty("apollo.loadConfigQPS");
        if (!Strings.isNullOrEmpty((String)customizedLoadConfigQPS)) {
            try {
                this.loadConfigQPS = Integer.parseInt(customizedLoadConfigQPS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!Strings.isNullOrEmpty((String)(customizedLongPollQPS = System.getProperty("apollo.longPollQPS")))) {
            try {
                this.longPollQPS = Integer.parseInt(customizedLongPollQPS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getLoadConfigQPS() {
        return this.loadConfigQPS;
    }

    public int getLongPollQPS() {
        return this.longPollQPS;
    }

    public long getOnErrorRetryInterval() {
        return this.onErrorRetryInterval;
    }

    public TimeUnit getOnErrorRetryIntervalTimeUnit() {
        return this.onErrorRetryIntervalTimeUnit;
    }

    public String getDefaultLocalCacheDir() {
        String cacheRoot = this.getCustomizedCacheRoot();
        if (!Strings.isNullOrEmpty((String)cacheRoot)) {
            return cacheRoot + File.separator + this.getAppId();
        }
        cacheRoot = this.isOSWindows() ? "C:\\opt\\data\\%s" : "/opt/data/%s";
        return String.format(cacheRoot, this.getAppId());
    }

    private String getCustomizedCacheRoot() {
        String cacheRoot = System.getProperty("apollo.cacheDir");
        if (Strings.isNullOrEmpty((String)cacheRoot)) {
            cacheRoot = System.getenv("APOLLO_CACHEDIR");
        }
        if (Strings.isNullOrEmpty((String)cacheRoot)) {
            cacheRoot = Foundation.server().getProperty("apollo.cacheDir", null);
        }
        return cacheRoot;
    }

    public boolean isInLocalMode() {
        try {
            return Env.LOCAL == this.getApolloEnv();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isOSWindows() {
        String osName = System.getProperty("os.name");
        if (Strings.isNullOrEmpty((String)osName)) {
            return false;
        }
        return osName.startsWith("Windows");
    }

    private void initMaxConfigCacheSize() {
        String customizedConfigCacheSize = System.getProperty("apollo.configCacheSize");
        if (!Strings.isNullOrEmpty((String)customizedConfigCacheSize)) {
            try {
                this.maxConfigCacheSize = Long.valueOf(customizedConfigCacheSize);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public long getMaxConfigCacheSize() {
        return this.maxConfigCacheSize;
    }

    public long getConfigCacheExpireTime() {
        return this.configCacheExpireTime;
    }

    public TimeUnit getConfigCacheExpireTimeUnit() {
        return this.configCacheExpireTimeUnit;
    }

    private void initLongPollingInitialDelayInMills() {
        String customizedLongPollingInitialDelay = System.getProperty("apollo.longPollingInitialDelayInMills");
        if (!Strings.isNullOrEmpty((String)customizedLongPollingInitialDelay)) {
            try {
                this.longPollingInitialDelayInMills = Long.valueOf(customizedLongPollingInitialDelay);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public long getLongPollingInitialDelayInMills() {
        return this.longPollingInitialDelayInMills;
    }

    private void initAutoUpdateInjectedSpringProperties() {
        String enableAutoUpdate = System.getProperty("apollo.autoUpdateInjectedSpringProperties");
        if (Strings.isNullOrEmpty((String)enableAutoUpdate)) {
            enableAutoUpdate = Foundation.app().getProperty("apollo.autoUpdateInjectedSpringProperties", null);
        }
        if (!Strings.isNullOrEmpty((String)enableAutoUpdate)) {
            this.autoUpdateInjectedSpringProperties = Boolean.parseBoolean(enableAutoUpdate.trim());
        }
    }

    public boolean isAutoUpdateInjectedSpringPropertiesEnabled() {
        return this.autoUpdateInjectedSpringProperties;
    }
}

