/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.DWResourceUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWApplicationClassLoader
extends URLClassLoader {
    private static Log _log = LogFactory.getLog(DWApplicationClassLoader.class);
    private static DWApplicationClassLoader dwApplicationClassLoader = null;
    private static final List<URL> urls;
    private Map<String, URL> _configFileURLs = new HashMap<String, URL>();
    private final ClassLoader system;

    public static List<URL> getJarURLs(String path) {
        FileFilter extensionFilter;
        ArrayList<URL> result = new ArrayList<URL>();
        File pathFile = DWResourceUtils.getResource(path);
        File[] filteredFiles = pathFile.listFiles(extensionFilter = DWApplicationClassLoader.getExtensionFilter("jar"));
        if (filteredFiles != null) {
            for (File filtersFile : filteredFiles) {
                try {
                    result.add(filtersFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    _log.error((Object)("Path to URL is error, path=" + path));
                }
            }
        }
        return result;
    }

    private static FileFilter getExtensionFilter(final String extensionName) {
        if (extensionName == null || extensionName.isEmpty()) {
            return null;
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return file.isFile() && file.getName().toLowerCase().endsWith("." + extensionName);
            }
        };
        return filter;
    }

    public static URL getURL(String path) {
        URL result = null;
        File file = DWResourceUtils.getResource(path);
        try {
            if (file != null) {
                result = file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            _log.error((Object)("Path to URL is error, path=" + path));
        }
        return result;
    }

    public static DWApplicationClassLoader getInstance() {
        if (dwApplicationClassLoader == null) {
            ClassLoader parent = DWApplicationClassLoader.getSystemClassLoader();
            URL[] urlsToArray = new URL[urls.size()];
            urls.toArray(urlsToArray);
            dwApplicationClassLoader = new DWApplicationClassLoader(urlsToArray, parent);
        }
        return dwApplicationClassLoader;
    }

    public DWApplicationClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        ClassLoader sys = DWApplicationClassLoader.getSystemClassLoader();
        while (sys.getParent() != null) {
            sys = sys.getParent();
        }
        this.system = sys;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.system != null) {
                try {
                    c = this.system.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        if (name != null && this._configFileURLs.containsKey(name.toLowerCase())) {
            return this._configFileURLs.get(name.toLowerCase());
        }
        URL url = null;
        if (name.endsWith("properties")) {
            url = this.findResource(name);
            if (url == null) {
                url = super.getResource(name);
            }
        } else {
            if (this.system != null) {
                url = this.system.getResource(name);
            }
            if (url == null && (url = this.findResource(name)) == null) {
                url = super.getResource(name);
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.system != null) {
            urls.addAll(Collections.list(this.system.getResources(name)));
        }
        urls.addAll(Collections.list(this.findResources(name)));
        ClassLoader parent = this.getParent();
        if (parent != null) {
            urls.addAll(Collections.list(parent.getResources(name)));
        }
        return Collections.enumeration(urls);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (name != null && this._configFileURLs.containsKey(name.toLowerCase())) {
            try {
                URL url = this._configFileURLs.get(name);
                File file = new File(url.toURI());
                FileInputStream fileStream = new FileInputStream(file);
                return fileStream;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getPlatformClassLoader() {
        return this.system;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParentLastURLCL\r\nURLs: ");
        sb.append(Arrays.asList(this.getURLs()));
        sb.append("\nParent CL: ");
        sb.append(this.getParent());
        sb.append("\nSystem CL: ");
        sb.append(this.system);
        sb.append("\n");
        return sb.toString();
    }

    static {
        String customizationConfPath = DWPathUtils.getCustomizationConfPath();
        String customizationLibPath = DWPathUtils.getCustomizationLibPath();
        String customizationLangPath = DWPathUtils.getCustomizationLangPath();
        String industryConfPath = DWPathUtils.getIndustryConfPath();
        String industryLibPath = DWPathUtils.getIndustryLibPath();
        String industryLangPath = DWPathUtils.getIndustryLangPath();
        String applicationConfPath = DWPathUtils.getApplicationConfPath();
        String applicationLibPath = DWPathUtils.getApplicationLibPath();
        String applicationLangPath = DWPathUtils.getApplicationLangPath();
        urls = new ArrayList<URL>();
        urls.add(DWApplicationClassLoader.getURL(customizationConfPath));
        urls.addAll(DWApplicationClassLoader.getJarURLs(customizationLibPath));
        urls.add(DWApplicationClassLoader.getURL(customizationLangPath));
        urls.add(DWApplicationClassLoader.getURL(industryConfPath));
        urls.addAll(DWApplicationClassLoader.getJarURLs(industryLibPath));
        urls.add(DWApplicationClassLoader.getURL(industryLangPath));
        urls.add(DWApplicationClassLoader.getURL(applicationConfPath));
        urls.addAll(DWApplicationClassLoader.getJarURLs(applicationLibPath));
        urls.add(DWApplicationClassLoader.getURL(applicationLangPath));
    }
}

