/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common;

import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.config.ConfigPool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class DWApplicationSpringUtils
implements ApplicationContextAware {
    public static final String SPRING_CONFIG_FILE_NAMES_SETTING = "springConfigFileNames";
    private static final String SPRING_CONFIG_FILE_NAME = "spring-application.xml";
    private static ConfigurableApplicationContext _context;
    private static Log _log;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ConfigPool pool = ConfigPool.getInstance();
        String[] configs = DWApplicationSpringUtils.getConfigs();
        ArrayList<InputStreamResource> resources = new ArrayList<InputStreamResource>();
        for (int i = 0; i < configs.length; ++i) {
            String springConfigFileName = configs[i];
            String xmlString = pool.getApplicationSpringXml(springConfigFileName);
            if (StringUtils.isBlank((CharSequence)xmlString)) continue;
            try {
                byte[] byteArray = xmlString.getBytes("UTF-8");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
                resources.add(new InputStreamResource((InputStream)byteArrayInputStream));
                continue;
            }
            catch (Exception e) {
                _log.error((Object)("[DWApplicationSpringUtils] " + e.getMessage()));
            }
        }
        InputStreamResource[] inputStreamResourceArray = resources.toArray(new InputStreamResource[resources.size()]);
        GenericXmlApplicationContext genericXmlApplicationContext = new GenericXmlApplicationContext();
        genericXmlApplicationContext.setClassLoader((ClassLoader)DWApplicationClassLoader.getInstance());
        genericXmlApplicationContext.setParent(applicationContext);
        genericXmlApplicationContext.setValidating(false);
        if (inputStreamResourceArray.length > 0) {
            genericXmlApplicationContext.load((Resource[])inputStreamResourceArray);
        }
        genericXmlApplicationContext.refresh();
        _context = genericXmlApplicationContext;
    }

    public static ApplicationContext getContext() {
        return _context;
    }

    public static <T> T getBean(String name) {
        Object bean = _context.getBean(name);
        if (bean == null) {
            return null;
        }
        return (T)bean;
    }

    public static boolean containsBean(String name) {
        return _context.containsBean(name);
    }

    private static String[] getConfigs() {
        String[] configs = null;
        ArrayList<String> configsTemp = new ArrayList<String>();
        String springConfigFileNamesSetting = DWApplicationConfigUtils.getProperty(SPRING_CONFIG_FILE_NAMES_SETTING);
        String[] targetConfigs = springConfigFileNamesSetting != null && springConfigFileNamesSetting.trim().length() > 0 ? springConfigFileNamesSetting.split(",") : new String[]{SPRING_CONFIG_FILE_NAME};
        for (String springConfigFileName : targetConfigs) {
            configsTemp.add(springConfigFileName);
        }
        configs = configsTemp.toArray(new String[configsTemp.size()]);
        return configs;
    }

    static {
        _log = LogFactory.getLog(DWApplicationSpringUtils.class);
    }
}

