/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.resource;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.service.DWServiceContext;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@Deprecated
public abstract class DWResourceBundle {
    public static final String KEY_LOCALE = "locale";
    public static final String DEFAULT_BASE_NAME = "messages";

    public static String getString(String key) {
        return DWResourceBundle.getString(DEFAULT_BASE_NAME, key);
    }

    public static String getString(String baseName, String key) {
        Locale locale = DWResourceBundle.getCurrentLocale();
        String value = DWResourceBundle.getString(baseName, locale, key);
        return value;
    }

    public static String getStringOrDefault(String key, String defaultVaule) {
        return DWResourceBundle.getStringOrDefault(DEFAULT_BASE_NAME, key, defaultVaule);
    }

    public static String getStringOrDefault(String baseName, String key, String defaultVaule) {
        Locale locale = DWResourceBundle.getCurrentLocale();
        String value = DWResourceBundle.getStringOrDefault(baseName, locale, key, defaultVaule);
        return value;
    }

    public static String getString(Locale locale, String key) {
        return DWResourceBundle.getString(DEFAULT_BASE_NAME, locale, key);
    }

    public static String getString(String baseName, Locale locale, String key) {
        return DWResourceBundle.getStringInAllLayers(baseName, locale, key);
    }

    private static String getStringInAllLayers(String baseName, Locale locale, String key) {
        String value = null;
        boolean found = false;
        MissingResourceException lastestEx = null;
        for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle(baseName, locale, cl);
                value = rb.getString(key);
                found = true;
                break;
            }
            catch (MissingResourceException e) {
                lastestEx = e;
                continue;
            }
        }
        if (found) {
            return value;
        }
        throw lastestEx;
    }

    public static String getStringOrDefault(Locale locale, String key, String defaultVaule) {
        return DWResourceBundle.getStringOrDefault(DEFAULT_BASE_NAME, locale, key, defaultVaule);
    }

    public static String getStringOrDefault(String baseName, Locale locale, String key, String defaultVaule) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ResourceBundle rb = ResourceBundle.getBundle(baseName, locale, cl);
        String value = defaultVaule;
        try {
            value = rb.getString(key);
        }
        catch (Throwable e) {
            return defaultVaule;
        }
        if (DWResourceBundle.isValueBlank(value)) {
            return defaultVaule;
        }
        return value;
    }

    public static Locale getCurrentLocale() {
        String localeString = null;
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        if (profile != null) {
            localeString = (String)profile.get(KEY_LOCALE);
        }
        if (localeString == null || localeString.isEmpty()) {
            return Locale.getDefault();
        }
        return DWResourceBundle.getLocale(localeString);
    }

    public static Locale getLocale(String localeString) {
        String[] parts = localeString.split("_");
        String lang = parts[0];
        String country = parts.length > 1 ? parts[1] : "";
        Locale locale = new Locale(lang, country);
        return locale;
    }

    public static String getString(String key, Object ... patternArguments) {
        return DWResourceBundle.getString(DEFAULT_BASE_NAME, key, patternArguments);
    }

    public static String getString(String baseName, String key, Object ... patternArguments) {
        String format = DWResourceBundle.getString(baseName, key);
        String formatResult = String.format(format, patternArguments);
        return formatResult;
    }

    public static String getStringOrDefault(String key, String defaultValue, Object ... patternArguments) {
        return DWResourceBundle.getStringOrDefault(DEFAULT_BASE_NAME, key, defaultValue, patternArguments);
    }

    public static String getStringOrDefault(String baseName, String key, String defaultValue, Object ... patternArguments) {
        String format = DWResourceBundle.getStringOrDefault(baseName, key, defaultValue);
        String formatResult = String.format(format, patternArguments);
        return formatResult;
    }

    private static boolean isValueBlank(String value) {
        return value == null || value.length() == 0;
    }

    public static String getBundleString(String baseName, String key) {
        Locale locale = DWResourceBundle.getCurrentLocale();
        return DWResourceBundle.getStringInAllLayers(baseName, locale, key);
    }

    public static String getModuleBundleString(String moduleName, String baseName, String key) {
        DWModuleClassLoader cl;
        Locale locale = DWResourceBundle.getCurrentLocale();
        ResourceBundle rb = ResourceBundle.getBundle(baseName, locale, cl = DWModuleClassLoader.getModuleClassLoaderByModuleName(moduleName));
        if (null != rb) {
            return rb.getString(key);
        }
        return null;
    }

    public static String getCurrentModuleBundleString(String baseName, String key) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        return DWResourceBundle.getModuleBundleString(moduleName, baseName, key);
    }
}

