/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.core.utils;

import com.ctrip.replica.apollo.core.utils.ClassLoaderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;

public class ResourceUtils {
    private static final String[] DEFAULT_FILE_SEARCH_LOCATIONS = new String[]{"./config/", "./"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readConfigFile(String configPath, Properties defaults) {
        Properties props = new Properties();
        if (defaults != null) {
            props.putAll((Map<?, ?>)defaults);
        }
        InputStream in = ResourceUtils.loadConfigFileFromDefaultSearchLocations(configPath);
        try {
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    private static InputStream loadConfigFileFromDefaultSearchLocations(String configPath) {
        try {
            InputStream in;
            for (String searchLocation : DEFAULT_FILE_SEARCH_LOCATIONS) {
                File candidate = Paths.get(searchLocation, configPath).toFile();
                if (!candidate.exists() || !candidate.isFile() || !candidate.canRead()) continue;
                return new FileInputStream(candidate);
            }
            URL url = ClassLoaderUtil.getLoader().getResource(configPath);
            if (url != null && (in = ResourceUtils.getResourceAsStream(url)) != null) {
                return in;
            }
            File candidate = new File(System.getProperty("user.dir"), configPath);
            if (candidate.exists() && candidate.isFile() && candidate.canRead()) {
                return new FileInputStream(candidate);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static InputStream getResourceAsStream(URL url) {
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

