/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.tracer.internals.cat;

import com.ctrip.replica.apollo.tracer.spi.Transaction;
import java.lang.reflect.Method;

public class CatTransaction
implements Transaction {
    private static Class CAT_TRANSACTION_CLASS;
    private static Method SET_STATUS_WITH_STRING;
    private static Method SET_STATUS_WITH_THROWABLE;
    private static Method ADD_DATA_WITH_KEY_AND_VALUE;
    private static Method COMPLETE;
    private Object catTransaction;

    static void init() {
    }

    public CatTransaction(Object catTransaction) {
        this.catTransaction = catTransaction;
    }

    @Override
    public void setStatus(String status) {
        try {
            SET_STATUS_WITH_STRING.invoke(this.catTransaction, status);
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void setStatus(Throwable status) {
        try {
            SET_STATUS_WITH_THROWABLE.invoke(this.catTransaction, status);
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void addData(String key, Object value) {
        try {
            ADD_DATA_WITH_KEY_AND_VALUE.invoke(this.catTransaction, key, value);
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void complete() {
        try {
            COMPLETE.invoke(this.catTransaction, new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    static {
        try {
            CAT_TRANSACTION_CLASS = Class.forName("com.dianping.cat.message.Transaction");
            SET_STATUS_WITH_STRING = CAT_TRANSACTION_CLASS.getMethod("setStatus", String.class);
            SET_STATUS_WITH_THROWABLE = CAT_TRANSACTION_CLASS.getMethod("setStatus", Throwable.class);
            ADD_DATA_WITH_KEY_AND_VALUE = CAT_TRANSACTION_CLASS.getMethod("addData", String.class, Object.class);
            COMPLETE = CAT_TRANSACTION_CLASS.getMethod("complete", new Class[0]);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Initialize Cat transaction failed", ex);
        }
    }
}

