/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.module.DWModuleFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class DWModuleClassLoader
extends URLClassLoader {
    private final ClassLoader applicationClassLoader;
    private String _moduleName;
    private List<String> _services = new ArrayList<String>();
    private static Map<String, DWModuleClassLoader> _moduleClassLoaders = new HashMap<String, DWModuleClassLoader>();
    private static ThreadLocal<String> _moduleInfo;
    Map<String, URL> _configFileURLs = new HashMap<String, URL>();

    public static void setCurrentModuleName(String moduleName) {
        if (_moduleInfo == null) {
            _moduleInfo = new ThreadLocal();
        }
        _moduleInfo.set(moduleName);
        DWModuleClassLoader moduleClassLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName(moduleName);
        Thread.currentThread().setContextClassLoader(moduleClassLoader);
    }

    public static String getCurrentModuleName() {
        if (_moduleInfo == null) {
            return null;
        }
        return _moduleInfo.get();
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public DWModuleClassLoader(ClassLoader parent) {
        this(new URL[0], parent);
    }

    private DWModuleClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        this.applicationClassLoader = parent;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.applicationClassLoader != null) {
                try {
                    c = this.applicationClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        if (name != null) {
            if (this._configFileURLs.containsKey(name.toLowerCase())) {
                return this._configFileURLs.get(name.toLowerCase());
            }
            if (name.contains("#")) {
                String[] parts = name.split("#");
                String moduleName = parts[0];
                String realResourceName = parts[1];
                DWModuleClassLoader moduleClassLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName(moduleName);
                return moduleClassLoader.getResource(realResourceName);
            }
        }
        URL url = null;
        if (name.endsWith("properties")) {
            url = this.findResource(name);
        } else {
            if (this.applicationClassLoader != null) {
                url = this.applicationClassLoader.getResource(name);
            }
            if (url == null && (url = this.findResource(name)) == null) {
                url = super.getResource(name);
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.applicationClassLoader != null) {
            urls.addAll(Collections.list(this.applicationClassLoader.getResources(name)));
        }
        urls.addAll(Collections.list(this.findResources(name)));
        ClassLoader parent = this.getParent();
        if (parent != null) {
            urls.addAll(Collections.list(parent.getResources(name)));
        }
        return Collections.enumeration(urls);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (name != null) {
            if (this._configFileURLs.containsKey(name.toLowerCase())) {
                try {
                    URL url = this._configFileURLs.get(name);
                    File file = new File(url.toURI());
                    FileInputStream fileStream = new FileInputStream(file);
                    return fileStream;
                }
                catch (Exception url) {
                    // empty catch block
                }
            }
            if (name.contains("#")) {
                String[] parts = name.split("#");
                String moduleName = parts[0];
                String realResourceName = parts[1];
                DWModuleClassLoader moduleClassLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName(moduleName);
                return moduleClassLoader.getResourceAsStream(realResourceName);
            }
        }
        return super.getResourceAsStream(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParentLastURLCL\r\nURLs: ");
        sb.append(Arrays.asList(this.getURLs()));
        sb.append("\nParent CL: ");
        sb.append(this.getParent());
        sb.append("\n");
        return sb.toString();
    }

    public void addServiceJarURL(URL url) {
        this.addURL(url);
    }

    public void addServiceInfo(String className) {
        if (!this._services.contains(className)) {
            this._services.add(className);
        }
    }

    @Deprecated
    public void addConfigFileURL(String fileName, URL url) {
    }

    public boolean hasService(String className) {
        return this._services.contains(className);
    }

    public List<String> getServiceInfo() {
        return Collections.unmodifiableList(this._services);
    }

    @Deprecated
    public static void addModuleClassLoader(String moduleName, DWModuleClassLoader classLoader) {
        String realModuleName;
        classLoader._moduleName = realModuleName = moduleName == null ? "default" : moduleName;
        _moduleClassLoaders.put(realModuleName, classLoader);
    }

    public static void addModuleClassLoader(String moduleName, DWModuleClassLoader classLoader, DWModuleFileInfo fileInfo) {
        String realModuleName;
        classLoader._moduleName = realModuleName = moduleName == null ? "default" : moduleName;
        String directoryLayer = fileInfo.getDirectoryLayer();
        _moduleClassLoaders.put(directoryLayer, classLoader);
    }

    public static String getModuleName(ClassLoader classLoader) {
        String moduleName = null;
        for (Map.Entry<String, DWModuleClassLoader> entry : _moduleClassLoaders.entrySet()) {
            if (entry.getValue() != classLoader) continue;
            moduleName = entry.getKey();
            break;
        }
        return moduleName;
    }

    public static DWModuleClassLoader getModuleClassLoaderByModuleName(String moduleName) {
        String moduleKey = moduleName;
        int keyLength = StringUtils.length((CharSequence)moduleName);
        if (_moduleClassLoaders != null) {
            for (Map.Entry<String, DWModuleClassLoader> entry : _moduleClassLoaders.entrySet()) {
                String key = entry.getKey();
                boolean isStartWithModuleName = StringUtils.equals((CharSequence)StringUtils.substringBefore((String)key, (String)"\\"), (CharSequence)moduleName);
                if (!isStartWithModuleName || StringUtils.length((CharSequence)key) <= keyLength) continue;
                keyLength = StringUtils.length((CharSequence)key);
                moduleKey = key;
            }
        }
        return _moduleClassLoaders.get(moduleKey);
    }

    public static DWModuleClassLoader getModuleClassLoaderByExactName(String moduleName) {
        return _moduleClassLoaders.get(moduleName);
    }

    public static DWModuleClassLoader getModuleClassLoader(String className) {
        String moduleName = DWModuleClassLoader.getCurrentModuleName();
        return DWModuleClassLoader.getModuleClassLoader(moduleName, className);
    }

    public static DWModuleClassLoader getModuleClassLoader(String moduleName, String className) {
        if (moduleName != null) {
            DWModuleClassLoader moduleClassLoader = _moduleClassLoaders.get(moduleName);
            if (moduleClassLoader == null || !moduleClassLoader.hasService(className)) {
                return null;
            }
            return moduleClassLoader;
        }
        DWModuleClassLoader loader = null;
        for (DWModuleClassLoader child : _moduleClassLoaders.values()) {
            if (!child.hasService(className)) continue;
            loader = child;
            break;
        }
        return loader;
    }

    public static void removeModuleClassLoader(String moduleName) {
        if (moduleName == null) {
            moduleName = "default";
        }
        if (_moduleClassLoaders.containsKey(moduleName)) {
            _moduleClassLoaders.remove(moduleName);
        }
    }

    public static String getModuleParentFolderName(boolean isLocalModule) {
        return isLocalModule ? "LocalService" : "Service";
    }
}

