/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.spring.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

public abstract class ApolloProcessor
implements BeanPostProcessor,
PriorityOrdered {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        for (Field field : this.findAllField(clazz)) {
            this.processField(bean, beanName, field);
        }
        for (Method method : this.findAllMethod(clazz)) {
            this.processMethod(bean, beanName, method);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected abstract void processField(Object var1, String var2, Field var3);

    protected abstract void processMethod(Object var1, String var2, Method var3);

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private List<Field> findAllField(Class clazz) {
        final LinkedList<Field> res = new LinkedList<Field>();
        ReflectionUtils.doWithFields((Class)clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                res.add(field);
            }
        });
        return res;
    }

    private List<Method> findAllMethod(Class clazz) {
        final LinkedList<Method> res = new LinkedList<Method>();
        ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                res.add(method);
            }
        });
        return res;
    }
}

