/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo;

import com.ctrip.replica.apollo.Config;
import com.ctrip.replica.apollo.ConfigFile;
import com.ctrip.replica.apollo.build.ApolloInjector;
import com.ctrip.replica.apollo.core.enums.ConfigFileFormat;
import com.ctrip.replica.apollo.internals.ConfigManager;
import com.ctrip.replica.apollo.spi.ConfigFactory;
import com.ctrip.replica.apollo.spi.ConfigRegistry;

public class PlatformConfigService {
    private static final PlatformConfigService s_instance = new PlatformConfigService();
    private volatile ConfigManager m_configManager;
    private volatile ConfigRegistry m_configRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigManager getManager() {
        if (this.m_configManager == null) {
            PlatformConfigService platformConfigService = this;
            synchronized (platformConfigService) {
                if (this.m_configManager == null) {
                    this.m_configManager = ApolloInjector.getInstance(ConfigManager.class);
                }
            }
        }
        return this.m_configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigRegistry getRegistry() {
        if (this.m_configRegistry == null) {
            PlatformConfigService platformConfigService = this;
            synchronized (platformConfigService) {
                if (this.m_configRegistry == null) {
                    this.m_configRegistry = ApolloInjector.getInstance(ConfigRegistry.class);
                }
            }
        }
        return this.m_configRegistry;
    }

    public static Config getAppConfig() {
        return PlatformConfigService.getConfig("application");
    }

    public static Config getConfig(String namespace) {
        return s_instance.getManager().getConfig(namespace);
    }

    public static ConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        return s_instance.getManager().getConfigFile(namespace, configFileFormat);
    }

    static void setConfig(Config config) {
        PlatformConfigService.setConfig("application", config);
    }

    static void setConfig(String namespace, final Config config) {
        s_instance.getRegistry().register(namespace, new ConfigFactory(){

            @Override
            public Config create(String namespace) {
                return config;
            }

            @Override
            public ConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
                return null;
            }
        });
    }

    static void setConfigFactory(ConfigFactory factory) {
        PlatformConfigService.setConfigFactory("application", factory);
    }

    static void setConfigFactory(String namespace, ConfigFactory factory) {
        s_instance.getRegistry().register(namespace, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        PlatformConfigService platformConfigService = s_instance;
        synchronized (platformConfigService) {
            PlatformConfigService.s_instance.m_configManager = null;
            PlatformConfigService.s_instance.m_configRegistry = null;
        }
    }
}

