/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.spring.property;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.util.StringUtils;

public class PlaceholderHelper {
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String VALUE_SEPARATOR = ":";
    private static final String SIMPLE_PLACEHOLDER_PREFIX = "{";
    private static final String EXPRESSION_PREFIX = "#{";
    private static final String EXPRESSION_SUFFIX = "}";

    public Object resolvePropertyValue(ConfigurableBeanFactory beanFactory, String beanName, String placeholder) {
        String strVal = beanFactory.resolveEmbeddedValue(placeholder);
        BeanDefinition bd = beanFactory.containsBean(beanName) ? beanFactory.getMergedBeanDefinition(beanName) : null;
        return this.evaluateBeanDefinitionString(beanFactory, strVal, bd);
    }

    private Object evaluateBeanDefinitionString(ConfigurableBeanFactory beanFactory, String value, BeanDefinition beanDefinition) {
        if (beanFactory.getBeanExpressionResolver() == null) {
            return value;
        }
        Scope scope = beanDefinition != null ? beanFactory.getRegisteredScope(beanDefinition.getScope()) : null;
        return beanFactory.getBeanExpressionResolver().evaluate(value, new BeanExpressionContext(beanFactory, scope));
    }

    public Set<String> extractPlaceholderKeys(String propertyString) {
        HashSet placeholderKeys = Sets.newHashSet();
        if (!this.isNormalizedPlaceholder(propertyString) && !this.isExpressionWithPlaceholder(propertyString)) {
            return placeholderKeys;
        }
        Stack<String> stack = new Stack<String>();
        stack.push(propertyString);
        while (!stack.isEmpty()) {
            String remainingPart;
            String strVal = (String)stack.pop();
            int startIndex = strVal.indexOf(PLACEHOLDER_PREFIX);
            if (startIndex == -1) {
                placeholderKeys.add(strVal);
                continue;
            }
            int endIndex = this.findPlaceholderEndIndex(strVal, startIndex);
            if (endIndex == -1) continue;
            String placeholderCandidate = strVal.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
            if (placeholderCandidate.startsWith(PLACEHOLDER_PREFIX)) {
                stack.push(placeholderCandidate);
            } else {
                int separatorIndex = placeholderCandidate.indexOf(VALUE_SEPARATOR);
                if (separatorIndex == -1) {
                    stack.push(placeholderCandidate);
                } else {
                    stack.push(placeholderCandidate.substring(0, separatorIndex));
                    String defaultValuePart = this.normalizeToPlaceholder(placeholderCandidate.substring(separatorIndex + VALUE_SEPARATOR.length()));
                    if (!Strings.isNullOrEmpty((String)defaultValuePart)) {
                        stack.push(defaultValuePart);
                    }
                }
            }
            if (endIndex + "}".length() >= strVal.length() - 1 || Strings.isNullOrEmpty((String)(remainingPart = this.normalizeToPlaceholder(strVal.substring(endIndex + "}".length()))))) continue;
            stack.push(remainingPart);
        }
        return placeholderKeys;
    }

    private boolean isNormalizedPlaceholder(String propertyString) {
        return propertyString.startsWith(PLACEHOLDER_PREFIX) && propertyString.endsWith("}");
    }

    private boolean isExpressionWithPlaceholder(String propertyString) {
        return propertyString.startsWith(EXPRESSION_PREFIX) && propertyString.endsWith("}") && propertyString.contains(PLACEHOLDER_PREFIX);
    }

    private String normalizeToPlaceholder(String strVal) {
        int startIndex = strVal.indexOf(PLACEHOLDER_PREFIX);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = strVal.lastIndexOf("}");
        if (endIndex == -1) {
            return null;
        }
        return strVal.substring(startIndex, endIndex + "}".length());
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + PLACEHOLDER_PREFIX.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (StringUtils.substringMatch((CharSequence)buf, (int)index, (CharSequence)"}")) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += "}".length();
                    continue;
                }
                return index;
            }
            if (StringUtils.substringMatch((CharSequence)buf, (int)index, (CharSequence)SIMPLE_PLACEHOLDER_PREFIX)) {
                ++withinNestedPlaceholder;
                index += SIMPLE_PLACEHOLDER_PREFIX.length();
                continue;
            }
            ++index;
        }
        return -1;
    }
}

