/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.internals;

import com.ctrip.replica.apollo.build.ApolloInjector;
import com.ctrip.replica.apollo.core.utils.ClassLoaderUtil;
import com.ctrip.replica.apollo.enums.ConfigSourceType;
import com.ctrip.replica.apollo.exceptions.ApolloConfigException;
import com.ctrip.replica.apollo.internals.AbstractConfigRepository;
import com.ctrip.replica.apollo.internals.ConfigRepository;
import com.ctrip.replica.apollo.internals.RepositoryChangeListener;
import com.ctrip.replica.apollo.tracer.Tracer;
import com.ctrip.replica.apollo.tracer.spi.Transaction;
import com.ctrip.replica.apollo.util.ConfigUtil;
import com.ctrip.replica.apollo.util.ExceptionUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;

public class LocalFileConfigRepository
extends AbstractConfigRepository
implements RepositoryChangeListener {
    private static final String CONFIG_DIR = "/config-cache";
    private final String m_namespace;
    private File m_baseDir;
    private final ConfigUtil m_configUtil;
    private volatile Properties m_fileProperties;
    private volatile ConfigRepository m_upstream;
    private volatile ConfigSourceType m_sourceType = ConfigSourceType.LOCAL;

    public LocalFileConfigRepository(String namespace) {
        this(namespace, null);
    }

    public LocalFileConfigRepository(String namespace, ConfigRepository upstream) {
        this.m_namespace = namespace;
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        this.setLocalCacheDir(this.findLocalCacheDir(), false);
        this.setUpstreamRepository(upstream);
        this.trySync();
    }

    void setLocalCacheDir(File baseDir, boolean syncImmediately) {
        this.m_baseDir = baseDir;
        this.checkLocalConfigCacheDir(this.m_baseDir);
        if (syncImmediately) {
            this.trySync();
        }
    }

    private File findLocalCacheDir() {
        try {
            String defaultCacheDir = this.m_configUtil.getDefaultLocalCacheDir();
            Path path = Paths.get(defaultCacheDir, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            if (Files.exists(path, new LinkOption[0]) && Files.isWritable(path)) {
                return new File(defaultCacheDir, CONFIG_DIR);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new File(ClassLoaderUtil.getClassPath(), CONFIG_DIR);
    }

    @Override
    public Properties getConfig() {
        if (this.m_fileProperties == null) {
            this.sync();
        }
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.m_fileProperties);
        return result;
    }

    @Override
    public void setUpstreamRepository(ConfigRepository upstreamConfigRepository) {
        if (upstreamConfigRepository == null) {
            return;
        }
        if (this.m_upstream != null) {
            this.m_upstream.removeChangeListener(this);
        }
        this.m_upstream = upstreamConfigRepository;
        this.trySyncFromUpstream();
        upstreamConfigRepository.addChangeListener(this);
    }

    @Override
    public ConfigSourceType getSourceType() {
        return this.m_sourceType;
    }

    @Override
    public void onRepositoryChange(String namespace, Properties newProperties) {
        if (newProperties.equals(this.m_fileProperties)) {
            return;
        }
        Properties newFileProperties = new Properties();
        newFileProperties.putAll((Map<?, ?>)newProperties);
        this.updateFileProperties(newFileProperties, this.m_upstream.getSourceType());
        this.fireRepositoryChange(namespace, newProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sync() {
        boolean syncFromUpstreamResultSuccess = this.trySyncFromUpstream();
        if (syncFromUpstreamResultSuccess) {
            return;
        }
        Transaction transaction = Tracer.newTransaction("Apollo.ConfigService", "syncLocalConfig");
        Throwable exception = null;
        try {
            transaction.addData("Basedir", this.m_baseDir.getAbsolutePath());
            this.m_fileProperties = this.loadFromLocalCacheFile(this.m_baseDir, this.m_namespace);
            this.m_sourceType = ConfigSourceType.LOCAL;
            transaction.setStatus("0");
        }
        catch (Throwable ex) {
            Tracer.logEvent("ApolloConfigException", ExceptionUtil.getDetailMessage(ex));
            transaction.setStatus(ex);
            exception = ex;
        }
        finally {
            transaction.complete();
        }
        if (this.m_fileProperties == null) {
            this.m_sourceType = ConfigSourceType.NONE;
            throw new ApolloConfigException("Load config from local config failed!", exception);
        }
    }

    private boolean trySyncFromUpstream() {
        if (this.m_upstream == null) {
            return false;
        }
        try {
            this.updateFileProperties(this.m_upstream.getConfig(), this.m_upstream.getSourceType());
            return true;
        }
        catch (Throwable ex) {
            Tracer.logError(ex);
            return false;
        }
    }

    private synchronized void updateFileProperties(Properties newProperties, ConfigSourceType sourceType) {
        this.m_sourceType = sourceType;
        if (newProperties.equals(this.m_fileProperties)) {
            return;
        }
        this.m_fileProperties = newProperties;
        this.persistLocalCacheFile(this.m_baseDir, this.m_namespace);
    }

    private Properties loadFromLocalCacheFile(File baseDir, String namespace) throws IOException {
        Preconditions.checkNotNull((Object)baseDir, (Object)"Basedir cannot be null");
        File file = this.assembleLocalCacheFile(baseDir, namespace);
        Properties properties = null;
        if (file.isFile() && file.canRead()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                properties = new Properties();
                properties.load(in);
            }
            catch (IOException ex) {
                Tracer.logError(ex);
                throw new ApolloConfigException(String.format("Loading config from local cache file %s failed", file.getAbsolutePath()), ex);
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        throw new ApolloConfigException(String.format("Cannot read from local cache file %s", file.getAbsolutePath()));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistLocalCacheFile(File baseDir, String namespace) {
        if (baseDir == null) {
            return;
        }
        File file = this.assembleLocalCacheFile(baseDir, namespace);
        FileOutputStream out = null;
        Transaction transaction = Tracer.newTransaction("Apollo.ConfigService", "persistLocalConfigFile");
        transaction.addData("LocalConfigFile", file.getAbsolutePath());
        try {
            out = new FileOutputStream(file);
            this.m_fileProperties.store(out, "Persisted by DefaultConfig");
            transaction.setStatus("0");
        }
        catch (IOException ex) {
            ApolloConfigException exception = new ApolloConfigException(String.format("Persist local cache file %s failed", file.getAbsolutePath()), ex);
            Tracer.logError(exception);
            transaction.setStatus(exception);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
            transaction.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLocalConfigCacheDir(File baseDir) {
        if (baseDir.exists()) {
            return;
        }
        Transaction transaction = Tracer.newTransaction("Apollo.ConfigService", "createLocalConfigDir");
        transaction.addData("BaseDir", baseDir.getAbsolutePath());
        try {
            Files.createDirectory(baseDir.toPath(), new FileAttribute[0]);
            transaction.setStatus("0");
        }
        catch (IOException ex) {
            ApolloConfigException exception = new ApolloConfigException(String.format("Create local config directory %s failed", baseDir.getAbsolutePath()), ex);
            Tracer.logError(exception);
            transaction.setStatus(exception);
        }
        finally {
            transaction.complete();
        }
    }

    File assembleLocalCacheFile(File baseDir, String namespace) {
        String fileName = String.format("%s.properties", Joiner.on((String)"+").join((Object)this.m_configUtil.getAppId(), (Object)this.m_configUtil.getCluster(), new Object[]{namespace}));
        return new File(baseDir, fileName);
    }
}

