/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.tracer;

import com.ctrip.replica.apollo.tracer.internals.DefaultMessageProducerManager;
import com.ctrip.replica.apollo.tracer.internals.NullMessageProducerManager;
import com.ctrip.replica.apollo.tracer.spi.MessageProducer;
import com.ctrip.replica.apollo.tracer.spi.MessageProducerManager;
import com.ctrip.replica.apollo.tracer.spi.Transaction;

public abstract class Tracer {
    private static final MessageProducerManager NULL_MESSAGE_PRODUCER_MANAGER = new NullMessageProducerManager();
    private static volatile MessageProducerManager producerManager;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MessageProducer getProducer() {
        block6: {
            try {
                if (producerManager != null) break block6;
                Object object = lock;
                synchronized (object) {
                    if (producerManager == null) {
                        producerManager = new DefaultMessageProducerManager();
                    }
                }
            }
            catch (Throwable ex) {
                producerManager = NULL_MESSAGE_PRODUCER_MANAGER;
            }
        }
        return producerManager.getProducer();
    }

    public static void logError(String message, Throwable cause) {
        try {
            Tracer.getProducer().logError(message, cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void logError(Throwable cause) {
        try {
            Tracer.getProducer().logError(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void logEvent(String type, String name) {
        try {
            Tracer.getProducer().logEvent(type, name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void logEvent(String type, String name, String status, String nameValuePairs) {
        try {
            Tracer.getProducer().logEvent(type, name, status, nameValuePairs);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Transaction newTransaction(String type, String name) {
        try {
            return Tracer.getProducer().newTransaction(type, name);
        }
        catch (Throwable ex) {
            return NULL_MESSAGE_PRODUCER_MANAGER.getProducer().newTransaction(type, name);
        }
    }

    static {
        lock = new Object();
        Tracer.getProducer();
    }
}

