/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.LinkedList;

public class ExceptionUtil {
    public static String getDetailMessage(Throwable ex) {
        int counter;
        if (ex == null || Strings.isNullOrEmpty((String)ex.getMessage())) {
            return "";
        }
        StringBuilder builder = new StringBuilder(ex.getMessage());
        LinkedList causes = Lists.newLinkedList();
        Throwable current = ex;
        for (counter = 0; current.getCause() != null && counter < 10; ++counter) {
            Throwable next = current.getCause();
            causes.add(next);
            current = next;
        }
        for (Throwable cause : causes) {
            if (Strings.isNullOrEmpty((String)cause.getMessage())) {
                --counter;
                continue;
            }
            builder.append(" [Cause: ").append(cause.getMessage());
        }
        builder.append(Strings.repeat((String)"]", (int)counter));
        return builder.toString();
    }
}

