/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.foundation;

import com.ctrip.replica.foundation.internals.DefaultProviderManager;
import com.ctrip.replica.foundation.internals.NullProviderManager;
import com.ctrip.replica.foundation.spi.ProviderManager;
import com.ctrip.replica.foundation.spi.provider.ApplicationProvider;
import com.ctrip.replica.foundation.spi.provider.NetworkProvider;
import com.ctrip.replica.foundation.spi.provider.ServerProvider;

public abstract class Foundation {
    private static Object lock = new Object();
    private static volatile ProviderManager s_manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProviderManager getManager() {
        try {
            if (s_manager == null) {
                Object object = lock;
                synchronized (object) {
                    if (s_manager == null) {
                        s_manager = new DefaultProviderManager();
                    }
                }
            }
            return s_manager;
        }
        catch (Throwable ex) {
            s_manager = new NullProviderManager();
            return s_manager;
        }
    }

    public static String getProperty(String name, String defaultValue) {
        try {
            return Foundation.getManager().getProperty(name, defaultValue);
        }
        catch (Throwable ex) {
            return defaultValue;
        }
    }

    public static NetworkProvider net() {
        try {
            return Foundation.getManager().provider(NetworkProvider.class);
        }
        catch (Exception ex) {
            return NullProviderManager.provider;
        }
    }

    public static ServerProvider server() {
        try {
            return Foundation.getManager().provider(ServerProvider.class);
        }
        catch (Exception ex) {
            return NullProviderManager.provider;
        }
    }

    public static ApplicationProvider app() {
        try {
            return Foundation.getManager().provider(ApplicationProvider.class);
        }
        catch (Exception ex) {
            return NullProviderManager.provider;
        }
    }

    static {
        Foundation.getManager();
    }
}

