/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.foundation.internals.provider;

import com.ctrip.replica.foundation.internals.Utils;
import com.ctrip.replica.foundation.internals.io.BOMInputStream;
import com.ctrip.replica.foundation.spi.provider.ApplicationProvider;
import com.ctrip.replica.foundation.spi.provider.Provider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class DefaultApplicationProvider
implements ApplicationProvider {
    public static final String APP_PROPERTIES_CLASSPATH = "/META-INF/app.properties";
    private Properties m_appProperties = new Properties();
    private String m_appId;

    @Override
    public void initialize() {
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(APP_PROPERTIES_CLASSPATH);
            if (in == null) {
                in = DefaultApplicationProvider.class.getResourceAsStream(APP_PROPERTIES_CLASSPATH);
            }
            this.initialize(in);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void initialize(InputStream in) {
        try {
            if (in != null) {
                try {
                    this.m_appProperties.load(new InputStreamReader((InputStream)new BOMInputStream(in), StandardCharsets.UTF_8));
                }
                finally {
                    in.close();
                }
            }
            this.initAppId();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getAppId() {
        return this.m_appId;
    }

    @Override
    public boolean isAppIdSet() {
        return !Utils.isBlank(this.m_appId);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        if ("app.id".equals(name)) {
            String val = this.getAppId();
            return val == null ? defaultValue : val;
        }
        String val = this.m_appProperties.getProperty(name, defaultValue);
        return val == null ? defaultValue : val;
    }

    @Override
    public Class<? extends Provider> getType() {
        return ApplicationProvider.class;
    }

    private void initAppId() {
        this.m_appId = System.getProperty("app.id");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            return;
        }
        this.m_appId = System.getenv("APP_ID");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            return;
        }
        this.m_appId = this.m_appProperties.getProperty("app.id");
        if (!Utils.isBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            return;
        }
        this.m_appId = null;
    }

    public String toString() {
        return "appId [" + this.getAppId() + "] properties: " + this.m_appProperties + " (DefaultApplicationProvider)";
    }
}

