/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.config.ConfigRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWLocalConfigRepository
implements ConfigRepository {
    private static Log _log = LogFactory.getLog(DWLocalConfigRepository.class);
    private static final String PROP_EXTENSIONS = ".properties";

    @Override
    public String getLog4j2Xml() {
        String path = DWPathUtils.getPlatformConfPath() + File.separator + "log4j2.xml";
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public String getPlatformModuleSpringXml(String module, String xmlName) {
        String path = DWPathUtils.getPlatformModuleConfPath(module) + File.separator + xmlName;
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public String getModuleSpringXml(String module, String xmlName) {
        String path = DWPathUtils.getApplicationModuleConfPath(module) + File.separator + xmlName;
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public String getApplicationSpringXml(String xmlName) {
        String path = DWPathUtils.getApplicationConfPath() + File.separator + xmlName;
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public String getPlatformSpringXml(String xmlName) {
        String path = DWPathUtils.getPlatformConfPath() + File.separator + xmlName;
        String xmlString = this.loadFileContent(path);
        return xmlString;
    }

    @Override
    public Properties getProperties(String path, String propertiesName) {
        Properties properties;
        block17: {
            properties = null;
            String fileName = path + File.separator + propertiesName + PROP_EXTENSIONS;
            File propertiesFile = new File(fileName);
            if (propertiesFile != null && propertiesFile.exists()) {
                try {
                    URL url = propertiesFile.toURI().toURL();
                    if (url == null) break block17;
                    try (InputStream propertyInputStream = url.openStream();){
                        properties = new Properties();
                        properties.load(propertyInputStream);
                    }
                    catch (IOException ioException) {
                        _log.error((Object)("DWLocalPropertiesRepository getProperties(String path, String propertiesName) failed! FileName=" + fileName + ", error message=" + ioException.getMessage()));
                        return null;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    _log.error((Object)("DWLocalPropertiesRepository getProperties(String path, String propertiesName) failed! FileName=" + fileName + ", error message=" + malformedURLException.getMessage()));
                    return null;
                }
            }
        }
        return properties;
    }

    private String loadFileContent(String path) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!new File(path).exists()) {
            return null;
        }
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> stringBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            _log.error((Object)("DWLocalPropertiesRepository loadFileContent(String path) failed! FileName=" + path + ", error message=" + e.getMessage()));
            return null;
        }
        String content = stringBuilder.toString();
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        return content;
    }
}

