/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.replica.apollo.tracer.internals.cat;

import com.ctrip.replica.apollo.tracer.internals.cat.CatTransaction;
import com.ctrip.replica.apollo.tracer.spi.MessageProducer;
import com.ctrip.replica.apollo.tracer.spi.Transaction;
import java.lang.reflect.Method;

public class CatMessageProducer
implements MessageProducer {
    private static Class CAT_CLASS;
    private static Method LOG_ERROR_WITH_CAUSE;
    private static Method LOG_ERROR_WITH_MESSAGE_AND_CAUSE;
    private static Method LOG_EVENT_WITH_TYPE_AND_NAME;
    private static Method LOG_EVENT_WITH_TYPE_AND_NAME_AND_STATUS_AND_NAME_VALUE_PAIRS;
    private static Method NEW_TRANSACTION_WITH_TYPE_AND_NAME;

    @Override
    public void logError(Throwable cause) {
        try {
            LOG_ERROR_WITH_CAUSE.invoke(null, cause);
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void logError(String message, Throwable cause) {
        try {
            LOG_ERROR_WITH_MESSAGE_AND_CAUSE.invoke(null, message, cause);
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void logEvent(String type, String name) {
        try {
            LOG_EVENT_WITH_TYPE_AND_NAME.invoke(null, type, name);
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void logEvent(String type, String name, String status, String nameValuePairs) {
        try {
            LOG_EVENT_WITH_TYPE_AND_NAME_AND_STATUS_AND_NAME_VALUE_PAIRS.invoke(null, type, name, status, nameValuePairs);
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Transaction newTransaction(String type, String name) {
        try {
            return new CatTransaction(NEW_TRANSACTION_WITH_TYPE_AND_NAME.invoke(null, type, name));
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    static {
        try {
            CAT_CLASS = Class.forName("com.dianping.cat.Cat");
            LOG_ERROR_WITH_CAUSE = CAT_CLASS.getMethod("logError", Throwable.class);
            LOG_ERROR_WITH_MESSAGE_AND_CAUSE = CAT_CLASS.getMethod("logError", String.class, Throwable.class);
            LOG_EVENT_WITH_TYPE_AND_NAME = CAT_CLASS.getMethod("logEvent", String.class, String.class);
            LOG_EVENT_WITH_TYPE_AND_NAME_AND_STATUS_AND_NAME_VALUE_PAIRS = CAT_CLASS.getMethod("logEvent", String.class, String.class, String.class, String.class);
            NEW_TRANSACTION_WITH_TYPE_AND_NAME = CAT_CLASS.getMethod("newTransaction", String.class, String.class);
            CatTransaction.init();
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Initialize Cat message producer failed", ex);
        }
    }
}

