/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config;

import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigFileChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.replica.apollo.PlatformConfigService;
import com.ctrip.replica.apollo.model.ConfigFileChangeEvent;
import com.digiwin.app.common.config.ConfigRepository;
import com.digiwin.app.common.config.ConfigType;
import com.digiwin.app.common.config.DWConfigFileChangeListener;
import com.digiwin.app.common.config.KeyPojo;
import com.digiwin.app.common.config.PathAnalyzer;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWRemoteConfigRepository
implements ConfigRepository {
    private static Log _log = LogFactory.getLog(DWRemoteConfigRepository.class);
    private static final String PLATFORM_PREFIX = "platform.";
    private Map<String, com.ctrip.replica.apollo.ConfigFile> platformRepository = new ConcurrentHashMap<String, com.ctrip.replica.apollo.ConfigFile>();
    private Map<String, ConfigFile> applicationRepository = new ConcurrentHashMap<String, ConfigFile>();

    public boolean addChangeListener(String key, final DWConfigFileChangeListener listener) {
        if (key.toLowerCase().contains(".xml") || key.toLowerCase().contains(".properties")) {
            key = key.substring(0, key.lastIndexOf(46));
        }
        if (this.applicationRepository.containsKey(key)) {
            ConfigFile configFile = this.applicationRepository.get(key);
            configFile.addChangeListener(new ConfigFileChangeListener(){

                public void onChange(com.ctrip.framework.apollo.model.ConfigFileChangeEvent changeEvent) {
                    String newValue = changeEvent.getNewValue();
                    String oldValue = changeEvent.getOldValue();
                    listener.onUpdate(newValue, oldValue);
                }
            });
            return true;
        }
        if (this.platformRepository.containsKey(key)) {
            com.ctrip.replica.apollo.ConfigFile configFile = this.platformRepository.get(key);
            configFile.addChangeListener(new com.ctrip.replica.apollo.ConfigFileChangeListener(){

                public void onChange(ConfigFileChangeEvent changeEvent) {
                    String newValue = changeEvent.getNewValue();
                    String oldValue = changeEvent.getOldValue();
                    listener.onUpdate(newValue, oldValue);
                }
            });
            return true;
        }
        return false;
    }

    public boolean addLog4j2XmlChangeListener(DWConfigFileChangeListener listener) {
        return this.addChangeListener("log4j2.xml", listener);
    }

    @Override
    public String getLog4j2Xml() {
        String content = this.getLog4j2XmlConfigFileString(ConfigType.APPLICATION, "log4j2.xml");
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public String getPlatformModuleSpringXml(String module, String xmlName) {
        String content = this.getSpringXmlConfigFileString(ConfigType.PLATFORM, module + "." + xmlName);
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public String getModuleSpringXml(String module, String xmlName) {
        String content = this.getSpringXmlConfigFileString(ConfigType.APPLICATION, module + "." + xmlName);
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public String getApplicationSpringXml(String xmlName) {
        String content = this.getSpringXmlConfigFileString(ConfigType.APPLICATION, xmlName);
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public String getPlatformSpringXml(String xmlName) {
        String content = this.getSpringXmlConfigFileString(ConfigType.PLATFORM, PLATFORM_PREFIX + xmlName);
        if (content == null) {
            return null;
        }
        return content;
    }

    @Override
    public Properties getProperties(String path, String propertiesName) {
        KeyPojo keyPojo = PathAnalyzer.getRemoteKey(path, propertiesName);
        String key = keyPojo.getKey();
        ConfigType configType = keyPojo.getConfigType();
        if (key == null) {
            return null;
        }
        String content = this.getConfigFileString(configType, key, ConfigFileFormat.Properties);
        if (content == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(content));
        }
        catch (IOException e) {
            _log.error((Object)("parse remote properties error, error message=" + e.getMessage()));
            return null;
        }
        return properties;
    }

    private String getSpringXmlConfigFileString(ConfigType configType, String key) {
        return this.getXmlConfigFileString(configType, key, false);
    }

    private String getLog4j2XmlConfigFileString(ConfigType configType, String key) {
        return this.getXmlConfigFileString(configType, key, true);
    }

    private String getXmlConfigFileString(ConfigType configType, String key, boolean isKeep) {
        if (key.toLowerCase().contains(".xml")) {
            key = key.substring(0, key.lastIndexOf(46));
        }
        String content = this.getConfigFileString(configType, key, ConfigFileFormat.XML);
        if (!isKeep) {
            if (ConfigType.APPLICATION.equals((Object)configType)) {
                if (this.applicationRepository.containsKey(key)) {
                    this.applicationRepository.remove(key);
                }
            } else if (ConfigType.PLATFORM.equals((Object)configType) && this.platformRepository.containsKey(key)) {
                this.platformRepository.remove(key);
            }
        }
        return content;
    }

    private String getConfigFileString(ConfigType configType, String key, ConfigFileFormat configFileFormat) {
        if (ConfigType.APPLICATION.equals((Object)configType)) {
            String content;
            ConfigFile configFile;
            if (!this.applicationRepository.containsKey(key)) {
                configFile = ConfigService.getConfigFile((String)key, (ConfigFileFormat)configFileFormat);
                this.applicationRepository.put(key, configFile);
            }
            if ((content = (configFile = this.applicationRepository.get(key)).getContent()) == null) {
                configFile = null;
                this.applicationRepository.remove(key);
                return null;
            }
            return content;
        }
        if (ConfigType.PLATFORM.equals((Object)configType)) {
            com.ctrip.replica.apollo.ConfigFile configFile;
            String content;
            if (!this.platformRepository.containsKey(key)) {
                String value = configFileFormat.getValue();
                com.ctrip.replica.apollo.ConfigFile configFile2 = PlatformConfigService.getConfigFile((String)key, (com.ctrip.replica.apollo.core.enums.ConfigFileFormat)com.ctrip.replica.apollo.core.enums.ConfigFileFormat.fromString((String)value));
                this.platformRepository.put(key, configFile2);
            }
            if ((content = (configFile = this.platformRepository.get(key)).getContent()) == null) {
                configFile = null;
                this.platformRepository.remove(key);
                return null;
            }
            return content;
        }
        return null;
    }
}

