/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DWPathUtils {
    private static Log _log = LogFactory.getLog(DWPathUtils.class);
    public static final String PLATFORM = "platform";
    public static final String APP = "application";
    public static final String INDUSTRY = "industry";
    public static final String CUSTOMIZATION = "customization";
    public static final String MODULE = "module";
    public static final String CONFIG = "conf";
    public static final String LIB = "lib";
    public static final String LANG = "lang";
    private static String BACKEND_PATH = DWPathUtils.getRunPath();
    private static String PLATFORM_CONF_PATH;
    private static String PLATFORM_LIB_PATH;
    private static String PLATFORM_MODULE_PATH;
    private static String PLATFORM_LANG_PATH;
    private static String APPLICATION_CONF_PATH;
    private static String APPLICATION_LIB_PATH;
    private static String APPLICATION_LANG_PATH;
    private static String APPLICATION_MODULE_PATH;
    private static String INDUSTRY_CONF_PATH;
    private static String INDUSTRY_LIB_PATH;
    private static String INDUSTRY_LANG_PATH;
    private static String INDUSTRY_MODULE_PATH;
    private static String CUSTOMIZATION_CONF_PATH;
    private static String CUSTOMIZATION_LIB_PATH;
    private static String CUSTOMIZATION_LANG_PATH;
    private static String CUSTOMIZATION_MODULE_PATH;

    public static void loadPath() {
        String basePlatformPath = BACKEND_PATH + File.separator + PLATFORM;
        PLATFORM_CONF_PATH = basePlatformPath + File.separator + CONFIG;
        PLATFORM_LIB_PATH = basePlatformPath + File.separator + LIB;
        PLATFORM_MODULE_PATH = basePlatformPath + File.separator + MODULE;
        PLATFORM_LANG_PATH = basePlatformPath + File.separator + LANG;
        String baseApplicationPath = BACKEND_PATH + File.separator + APP;
        APPLICATION_CONF_PATH = baseApplicationPath + File.separator + CONFIG;
        APPLICATION_LIB_PATH = baseApplicationPath + File.separator + LIB;
        APPLICATION_LANG_PATH = baseApplicationPath + File.separator + LANG;
        APPLICATION_MODULE_PATH = baseApplicationPath + File.separator + MODULE;
        String baseIndustryPath = baseApplicationPath + File.separator + INDUSTRY;
        INDUSTRY_CONF_PATH = baseIndustryPath + File.separator + CONFIG;
        INDUSTRY_LIB_PATH = baseIndustryPath + File.separator + LIB;
        INDUSTRY_LANG_PATH = baseIndustryPath + File.separator + LANG;
        INDUSTRY_MODULE_PATH = baseIndustryPath + File.separator + MODULE;
        String baseCustomizationPath = baseApplicationPath + File.separator + CUSTOMIZATION;
        CUSTOMIZATION_CONF_PATH = baseCustomizationPath + File.separator + CONFIG;
        CUSTOMIZATION_LIB_PATH = baseCustomizationPath + File.separator + LIB;
        CUSTOMIZATION_LANG_PATH = baseCustomizationPath + File.separator + LANG;
        CUSTOMIZATION_MODULE_PATH = baseCustomizationPath + File.separator + MODULE;
    }

    private static void log() {
        String logFormat = "[%s]%s=%s";
        String logClass = DWPathUtils.class.getName();
        _log.debug((Object)String.format(logFormat, logClass, "BackendPath=", BACKEND_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "PlatformConfPath=", PLATFORM_CONF_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "PlatformLibPath=", PLATFORM_LIB_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "PlatformModulePath=", PLATFORM_MODULE_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "PlatformLangPath=", PLATFORM_LANG_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "ApplicationConfPath=", APPLICATION_CONF_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "ApplicationLibPath=", APPLICATION_LIB_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "ApplicationLangPath=", APPLICATION_LANG_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "ApplicationModulePath=", APPLICATION_MODULE_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "IndustryConfPath=", INDUSTRY_CONF_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "IndustryLibPath=", INDUSTRY_LIB_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "IndustryLangPath=", INDUSTRY_LANG_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "IndustryModulePath=", INDUSTRY_MODULE_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "CustomizationConfPath=", CUSTOMIZATION_CONF_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "CustomizationLibPath=", CUSTOMIZATION_LIB_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "CustomizationLangPath=", CUSTOMIZATION_LANG_PATH));
        _log.debug((Object)String.format(logFormat, logClass, "CustomizationModulePath=", CUSTOMIZATION_MODULE_PATH));
    }

    public static String getConnAuthKeyPath() throws Exception {
        File backendFolder = new File(DWPathUtils.getBackendPath());
        File applicationFolder = backendFolder.getParentFile();
        File[] digiwinFolder = applicationFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return "digiwin".equalsIgnoreCase(name);
            }
        });
        if (digiwinFolder.length == 0) {
            throw new Exception("Digiwin folder don't exist");
        }
        File[] updateFolder = digiwinFolder[0].listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return "update".equalsIgnoreCase(name);
            }
        });
        if (updateFolder.length == 0) {
            throw new Exception("Update folder don't exist");
        }
        File[] connAuthKeyFile = updateFolder[0].listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return "ConnAuthKey".equalsIgnoreCase(name);
            }
        });
        if (connAuthKeyFile.length == 0) {
            throw new Exception("ConnAuthKey don't exist");
        }
        return connAuthKeyFile[0].getAbsolutePath();
    }

    public static String getRunPath() {
        String userDir = System.getProperty("user.dir");
        return userDir;
    }

    public static String getBackendPath() {
        return BACKEND_PATH;
    }

    public static String getPlatformConfPath() {
        return PLATFORM_CONF_PATH;
    }

    public static boolean isPlatformConfPath(String path) {
        return PLATFORM_CONF_PATH.equals(path);
    }

    public static String getPlatformModulePath() {
        return PLATFORM_MODULE_PATH;
    }

    public static String getPlatformLangPath() {
        return PLATFORM_LANG_PATH;
    }

    public static String getPlatformLibPath() {
        return PLATFORM_LIB_PATH;
    }

    public static String getPlatformModulePath(String moduleName) {
        return DWPathUtils.getPlatformModulePath() + File.separator + moduleName;
    }

    public static String getPlatformModuleConfPath(String moduleName) {
        return DWPathUtils.getPlatformModulePath(moduleName) + File.separator + CONFIG;
    }

    public static boolean isPlatformModuleConfPath(String path) {
        return path.startsWith(DWPathUtils.getPlatformModulePath() + File.separator) && path.endsWith(File.separator + CONFIG);
    }

    public static String getPlatformModuleLibPath(String moduleName) {
        return DWPathUtils.getPlatformModulePath(moduleName) + File.separator + LIB;
    }

    public static String getPlatformModuleLangPath(String moduleName) {
        return DWPathUtils.getPlatformModulePath(moduleName) + File.separator + LANG;
    }

    public static String getApplicationConfPath() {
        return APPLICATION_CONF_PATH;
    }

    public static boolean isApplicationConfPath(String path) {
        return APPLICATION_CONF_PATH.equals(path);
    }

    public static String getApplicationLibPath() {
        return APPLICATION_LIB_PATH;
    }

    public static String getApplicationLangPath() {
        return APPLICATION_LANG_PATH;
    }

    public static String getApplicationModulePath() {
        return APPLICATION_MODULE_PATH;
    }

    public static String getApplicationModulePath(String moduleName) {
        return DWPathUtils.getApplicationModulePath() + File.separator + moduleName;
    }

    public static String getApplicationModuleConfPath(String moduleName) {
        return DWPathUtils.getApplicationModulePath(moduleName) + File.separator + CONFIG;
    }

    public static boolean isApplicationModuleConfPath(String path) {
        return path.startsWith(DWPathUtils.getApplicationModulePath() + File.separator) && path.endsWith(File.separator + CONFIG);
    }

    public static String getApplicationModuleLibPath(String moduleName) {
        return DWPathUtils.getApplicationModulePath(moduleName) + File.separator + LIB;
    }

    public static String getApplicationModuleLangPath(String moduleName) {
        return DWPathUtils.getApplicationModulePath(moduleName) + File.separator + LANG;
    }

    public static String getIndustryConfPath() {
        return INDUSTRY_CONF_PATH;
    }

    public static String getIndustryLibPath() {
        return INDUSTRY_LIB_PATH;
    }

    public static String getIndustryLangPath() {
        return INDUSTRY_LANG_PATH;
    }

    public static String getIndustryModulePath() {
        return INDUSTRY_MODULE_PATH;
    }

    public static String getIndustryModulePath(String moduleName) {
        return DWPathUtils.getIndustryModulePath() + File.separator + moduleName;
    }

    public static String getIndustryModuleConfPath(String moduleName) {
        return DWPathUtils.getIndustryModulePath(moduleName) + File.separator + CONFIG;
    }

    public static String getIndustryModuleLibPath(String moduleName) {
        return DWPathUtils.getIndustryModulePath(moduleName) + File.separator + LIB;
    }

    public static String getIndustryModuleLangPath(String moduleName) {
        return DWPathUtils.getIndustryModulePath(moduleName) + File.separator + LANG;
    }

    public static String getCustomizationConfPath() {
        return CUSTOMIZATION_CONF_PATH;
    }

    public static String getCustomizationLibPath() {
        return CUSTOMIZATION_LIB_PATH;
    }

    public static String getCustomizationLangPath() {
        return CUSTOMIZATION_LANG_PATH;
    }

    public static String getCustomizationModulePath() {
        return CUSTOMIZATION_MODULE_PATH;
    }

    public static String getCustomizationModulePath(String moduleName) {
        return DWPathUtils.getCustomizationModulePath() + File.separator + moduleName;
    }

    public static String getCustomizationModuleConfPath(String moduleName) {
        return DWPathUtils.getCustomizationModulePath(moduleName) + File.separator + CONFIG;
    }

    public static String getCustomizationModuleLibPath(String moduleName) {
        return DWPathUtils.getCustomizationModulePath(moduleName) + File.separator + LIB;
    }

    public static String getCustomizationModuleLangPath(String moduleName) {
        return DWPathUtils.getCustomizationModulePath(moduleName) + File.separator + LANG;
    }

    static {
        DWPathUtils.loadPath();
        DWPathUtils.log();
    }
}

