/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import com.digiwin.app.service.TokenBean;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;

public class DWLoginResult<TResult>
implements Serializable {
    private LoginPolicy _loginPolicy = null;
    private Map<String, Object> _profile = null;
    private TResult _result = null;
    private TokenBean<TResult> _tokenBean = null;

    public DWLoginResult() {
    }

    public DWLoginResult(Map<String, Object> profile, TResult result) {
        if (profile == null) {
            throw new IllegalArgumentException();
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        String primerKey = UUID.randomUUID().toString();
        profile.put("primerKey", primerKey);
        this._profile = profile;
        this._result = result;
        TokenBean<TResult> tokenBean = new TokenBean<TResult>(primerKey, profile, result);
        this._tokenBean = tokenBean;
    }

    public DWLoginResult(TokenBean<TResult> tokenBean) {
        this._tokenBean = tokenBean;
        this._profile = tokenBean.getProfile();
        this._result = tokenBean.getResult();
        this._loginPolicy = tokenBean.getLoginPolicy();
        if (this._profile == null) {
            throw new IllegalArgumentException();
        }
        if (this._result == null) {
            throw new IllegalArgumentException();
        }
        if (this._loginPolicy == null) {
            throw new IllegalArgumentException();
        }
        this._profile.put("primerKey", tokenBean.getPrimerKey());
    }

    public LoginPolicy getLoginPolicy() {
        return this._loginPolicy;
    }

    public Map<String, Object> getProfile() {
        return this._profile;
    }

    public TResult getResult() {
        return this._result;
    }

    public TokenBean<TResult> getTokenBean() {
        return this._tokenBean;
    }

    public static enum LoginPolicy {
        ALLOW_MULTIPLE_LOGIN,
        KICK_PRIOR;

    }
}

