/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.module.DWModuleSusspendedInvocationHandler;
import com.digiwin.app.module.DWModuleSusspendedService;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.DWServiceBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class DWServiceInfo {
    private static DWServiceBuilder builder;
    private String _moduleName = null;
    private Class<?> _interfaceType = null;
    private Class<?> _implementationType;
    private DWService _instance;

    public static void setServiceBuilder(DWServiceBuilder builder) {
        DWServiceInfo.builder = builder;
    }

    public DWServiceInfo(String moduleName, Class<?> interfaceType, Class<?> implementationType) {
        this._moduleName = moduleName;
        this._interfaceType = interfaceType;
        this._implementationType = implementationType;
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public Class<?> getInterfaceType() {
        return this._interfaceType;
    }

    public Class<?> getImplementationType() {
        return this._implementationType;
    }

    public DWService getInstance() throws Exception {
        if (this._instance == null) {
            this._instance = DWServiceInfo.createInstance(this, this._moduleName);
        }
        return this._instance;
    }

    private static DWService createInstance(DWServiceInfo serviceInfo, String groupName) throws Exception {
        DWService instance = null;
        Class<?> implementationType = serviceInfo.getImplementationType();
        if (builder == null) {
            throw new IllegalAccessException("Global DWServiceBuilder has not been set yet!");
        }
        try {
            instance = (DWService)builder.build(implementationType, groupName);
        }
        catch (Throwable e) {
            return DWServiceInfo.createMockService(serviceInfo, e);
        }
        return instance;
    }

    private static DWService createMockService(DWServiceInfo serviceInfo, Throwable e) {
        DWService mockSevvrvice = null;
        ClassLoader cl = serviceInfo.getInterfaceType().getClassLoader();
        Class<?> mainInterface = serviceInfo.getInterfaceType();
        Class[] interfaces = new Class[]{mainInterface, DWService.class, DWModuleSusspendedService.class};
        mockSevvrvice = (DWService)Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)new DWModuleSusspendedInvocationHandler(serviceInfo, e));
        return mockSevvrvice;
    }
}

