/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config.remote;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.group.GroupConfigFile;
import com.digiwin.apollo.group.GroupConfigService;
import com.digiwin.app.common.DWApplicationClassLoader;
import com.digiwin.app.common.config.ConfigType;
import com.digiwin.app.common.config.Extension;
import com.digiwin.app.common.config.ExtensionUtils;
import com.digiwin.app.common.config.reader.BaseGroupReader;
import com.digiwin.app.common.config.reader.resource.LocaleReader;
import com.digiwin.app.common.config.remote.ConfigInfo;
import com.digiwin.app.module.DWModuleClassLoader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupReader
implements BaseGroupReader {
    private static final String TAG = "[GroupReader] ";
    private static Log _log = LogFactory.getLog(GroupReader.class);

    @Override
    public String getGroupLog4j2Xml() {
        String content = this.getGroupConfigFileString("log4j2", ConfigFileFormat.XML);
        if (StringUtils.isBlank((CharSequence)content)) {
            _log.debug((Object)"[GroupReader] can't find from remote group - log4j2");
            return null;
        }
        return content;
    }

    @Override
    public String getGroupModuleSpringXml(String xmlNameWithoutExtension) {
        String key = "share." + xmlNameWithoutExtension;
        String content = this.getGroupConfigFileString(key, ConfigFileFormat.XML);
        if (StringUtils.isBlank((CharSequence)content)) {
            _log.debug((Object)("[GroupReader] can't find from remote group - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getGroupApplicationSpringXml(String xmlNameWithoutExtension) {
        String key = xmlNameWithoutExtension;
        String content = this.getGroupConfigFileString(key, ConfigFileFormat.XML);
        if (StringUtils.isBlank((CharSequence)content)) {
            _log.debug((Object)("[GroupReader] can't find from remote group - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getGroupModuleResource(String nameWithoutExtension, Extension extension) {
        ConfigFileFormat configFileFormat;
        String key = "share." + nameWithoutExtension;
        String content = this.getGroupConfigFileString(key, configFileFormat = ExtensionUtils.toConfigFileFormat(extension));
        if (StringUtils.isBlank((CharSequence)content)) {
            _log.debug((Object)("[GroupReader] can't find from remote group - " + key));
            return null;
        }
        return content;
    }

    @Override
    public String getGroupApplicationResource(String nameWithoutExtension, Extension extension) {
        String key = nameWithoutExtension;
        ConfigFileFormat configFileFormat = ExtensionUtils.toConfigFileFormat(extension);
        String content = this.getGroupConfigFileString(key, configFileFormat);
        if (StringUtils.isBlank((CharSequence)content)) {
            _log.debug((Object)("[GroupReader] can't find from remote group - " + key));
            return null;
        }
        return content;
    }

    @Override
    public Properties getGroupProperties(String path, String propertiesNameWithoutExtension) {
        ConfigInfo configInfo = ConfigInfo.get(path, propertiesNameWithoutExtension);
        return this.getGroupProperties(configInfo);
    }

    private Properties getGroupProperties(ConfigInfo configInfo) {
        String content;
        if (configInfo == null) {
            return new Properties();
        }
        ConfigType configType = configInfo.getConfigType();
        String fileNameWithoutExtension = configInfo.getFileNameWithoutExtension();
        if (ConfigType.PLATFORM.equals((Object)configType)) {
            return new Properties();
        }
        String key = fileNameWithoutExtension;
        if (ConfigType.MODULE.equals((Object)configType)) {
            key = "share." + fileNameWithoutExtension;
        }
        if (StringUtils.isBlank((CharSequence)(content = this.getGroupConfigFileString(key, ConfigFileFormat.Properties)))) {
            _log.debug((Object)("[GroupReader] can't find from remote group - " + key));
            return new Properties();
        }
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(content));
        }
        catch (IOException e) {
            _log.error((Object)("parse remote properties error, error message=" + e.getMessage()));
            return new Properties();
        }
        return properties;
    }

    @Override
    public String getGroupApplicationString(String baseName, String key, Object ... patternArguments) {
        return this.getGroupApplicationString(baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
    }

    private String getGroupApplicationString(String baseName, Locale locale, String key, Object ... patternArguments) {
        String fileNameWithoutExtension = baseName;
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            fileNameWithoutExtension = fileNameWithoutExtension + "_" + locale;
        }
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigType(ConfigType.APPLICATION);
        configInfo.setFileNameWithoutExtension(fileNameWithoutExtension);
        configInfo.setModifiedFileName(fileNameWithoutExtension);
        Properties properties = this.getGroupProperties(configInfo);
        if (properties.containsKey(key)) {
            String groupApplicationString = (String)properties.get(key);
            if (patternArguments != null) {
                groupApplicationString = String.format(groupApplicationString, patternArguments);
            }
            return groupApplicationString;
        }
        _log.debug((Object)("[GroupReader] can't find from remote group - " + key));
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            String groupApplicationString = this.getGroupApplicationString(baseName, null, key, patternArguments);
            return groupApplicationString;
        }
        return null;
    }

    @Override
    public String getGroupModuleString(String baseName, String key, Object ... patternArguments) {
        return this.getGroupModuleString(baseName, LocaleReader.getCurrentLocale(), key, patternArguments);
    }

    private String getGroupModuleString(String baseName, Locale locale, String key, Object ... patternArguments) {
        String fileNameWithoutExtension = baseName;
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            fileNameWithoutExtension = fileNameWithoutExtension + "_" + locale;
        }
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigType(ConfigType.MODULE);
        configInfo.setFileNameWithoutExtension(fileNameWithoutExtension);
        Properties properties = this.getGroupProperties(configInfo);
        if (properties.containsKey(key)) {
            String groupModuleString = (String)properties.get(key);
            if (patternArguments != null) {
                groupModuleString = String.format(groupModuleString, patternArguments);
            }
            return groupModuleString;
        }
        _log.debug((Object)("[GroupReader] can't find from remote group - " + key));
        if (locale != null && StringUtils.isNotBlank((CharSequence)locale.toString())) {
            String groupModuleString = this.getGroupModuleString(baseName, null, key, patternArguments);
            return groupModuleString;
        }
        return null;
    }

    @Override
    public String getGroupString(ClassLoader cl, String baseName, Locale locale, String key, Object ... patternArguments) {
        if (cl.equals(DWApplicationClassLoader.getInstance().getPlatformClassLoader())) {
            return null;
        }
        if (cl.equals((Object)DWApplicationClassLoader.getInstance())) {
            return this.getGroupApplicationString(baseName, locale, key, patternArguments);
        }
        String moduleName = DWModuleClassLoader.getModuleName(cl);
        return this.getGroupModuleString(moduleName, baseName, locale, key, patternArguments);
    }

    private String getGroupConfigFileString(String nameWithoutExtension, ConfigFileFormat configFileFormat) {
        GroupConfigFile groupConfigFile = GroupConfigService.getConfigFile((String)nameWithoutExtension, (ConfigFileFormat)configFileFormat);
        String groupContent = groupConfigFile.getContent();
        return groupContent;
    }
}

