/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service;

import com.digiwin.app.adapter.ProfileAdapter;
import com.digiwin.app.adapter.RequestAdapter;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class DWServiceContext {
    private static ThreadLocal<DWServiceContext> _currentContext = new ThreadLocal();
    private String _uuid = null;
    private Map<String, Object> _profile = null;
    @Deprecated
    private String _moduleName = null;
    private String _groupName = null;
    private List<Long> _durations = new ArrayList<Long>();
    private boolean _async = false;
    private transient Future<?> _future = null;
    private String _token = null;
    private Map<String, Object> _requestHeader = new HashMap<String, Object>();
    private String _requestBody = null;
    private Map<String, Object> _responseHeader = new HashMap<String, Object>();
    private int _statusCode = 200;
    private boolean _standardResult = true;
    private boolean _disableResultHandler = true;
    private String traceId;
    private String requestURI;
    private String digiServiceName = null;
    protected boolean _allowCrossTenant = false;
    private Map<String, Object> operateLog = new HashMap<String, Object>();
    private Map<String, Object> data = new HashMap<String, Object>();

    public static DWServiceContext getContext() {
        DWServiceContext context = _currentContext.get();
        if (context == null) {
            context = new DWServiceContext();
            _currentContext.set(context);
        }
        return context;
    }

    public static void setContext(DWServiceContext serviceContext) {
        _currentContext.set(serviceContext);
    }

    public String getUUID() {
        return this._uuid;
    }

    public void setUUID(String uuid) {
        this._uuid = uuid;
    }

    public Map<String, Object> getProfile() {
        if (this._profile == null) {
            ProfileAdapter profileAdapter = null;
            try {
                profileAdapter = (ProfileAdapter)SpringContextUtils.getBean((String)"profileAdapter");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (profileAdapter != null) {
                return profileAdapter.getProfile();
            }
        }
        return this._profile;
    }

    public void setProfile(Map<String, Object> profile) {
        this._profile = profile;
    }

    public long getDuration() {
        if (this._durations != null && this._durations.size() > 0) {
            return this._durations.get(this._durations.size() - 1);
        }
        return 0L;
    }

    public List<Long> getDurations() {
        return Collections.unmodifiableList(this._durations);
    }

    public void pushDuration(long duration) {
        this._durations.add(duration);
    }

    @Deprecated
    public String getModuleName() {
        return this._moduleName;
    }

    @Deprecated
    public void setModuleName(String moduleName) {
        this._moduleName = moduleName;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    public boolean isAsync() {
        return this._async;
    }

    public void setAsync(boolean async) {
        this._async = async;
    }

    public void setFuture(Future<?> future) {
        this._future = future;
    }

    public Future<?> getFuture() {
        return this._future;
    }

    public String getToken() {
        if (this._token == null) {
            RequestAdapter requestAdapter = null;
            try {
                requestAdapter = (RequestAdapter)SpringContextUtils.getBean((String)"requestAdapter");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (requestAdapter != null) {
                return requestAdapter.getToken();
            }
        }
        return this._token;
    }

    public void setToken(String token) {
        this._token = token;
    }

    public Map<String, Object> getRequestHeader() {
        if (this._requestHeader.size() == 0) {
            RequestAdapter requestAdapter = null;
            try {
                requestAdapter = (RequestAdapter)SpringContextUtils.getBean((String)"requestAdapter");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (requestAdapter != null) {
                Map requestHeader = requestAdapter.getRequestHeader();
                if (requestHeader == null) {
                    return new HashMap<String, Object>();
                }
                return requestAdapter.getRequestHeader();
            }
        }
        return this._requestHeader;
    }

    public void setRequestHeader(Map<String, Object> requestHeader) {
        this._requestHeader = requestHeader;
    }

    public String getRequestBody() {
        return this._requestBody;
    }

    public void setRequestBody(String requestBody) {
        this._requestBody = requestBody;
    }

    public Map<String, Object> getResponseHeader() {
        return this._responseHeader;
    }

    public void setResponseHeader(Map<String, Object> responseHeader) {
        this._responseHeader = responseHeader;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public void setStatusCode(int statusCode) {
        this._statusCode = statusCode;
    }

    public boolean getStandardResult() {
        return this._standardResult;
    }

    public void setStandardResult(boolean _standardResult) {
        this._standardResult = _standardResult;
    }

    public boolean getResultHandlerEnabled() {
        return this._disableResultHandler;
    }

    public void disableResultHandler() {
        this._disableResultHandler = false;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getDigiServiceName() {
        return this.digiServiceName;
    }

    public void setDigiServiceName(String digiServiceName) {
        this.digiServiceName = digiServiceName;
    }

    public boolean getAllowCrossTenant() {
        return this._allowCrossTenant;
    }

    public void setAllowCrossTenant(boolean allowCrossTenant) {
        this._allowCrossTenant = allowCrossTenant;
    }

    public Map<String, Object> getOperateLog() {
        return this.operateLog;
    }

    public void setOperateLog(Map<String, Object> operateLog) {
        this.operateLog = operateLog;
    }

    public void set(String key, Object value) {
        this.data.put(key, value);
    }

    public <T> T get(String key, T defaultValue) {
        Object value = this.data.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public void remove() {
        _currentContext.remove();
    }

    @Deprecated
    public void clear() {
        this._uuid = null;
        this._moduleName = null;
        this._profile = null;
        this._durations.clear();
        this._async = false;
        this._future = null;
        this._token = null;
        this._requestHeader = new HashMap<String, Object>();
        this._requestBody = null;
        this._responseHeader = new HashMap<String, Object>();
        this._statusCode = 200;
        this._standardResult = true;
        this._disableResultHandler = true;
        this.traceId = null;
        this.requestURI = null;
        this.digiServiceName = null;
        this.operateLog = new HashMap<String, Object>();
        this.data = new HashMap<String, Object>();
    }
}

