/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common;

import com.digiwin.app.common.DWPropertiesUtils;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class DWApplicationConfigUtils
extends PropertyPlaceholderConfigurer {
    private static final String PLATORM_CONFIG_PROPERTIES = "platform";
    private static final String APPLICATION_CONFIG_PROPERTIES = "application";

    public int getOrder() {
        return -1000;
    }

    public static Properties getProperties() {
        Properties customizationProperties;
        Properties industryProperties;
        Properties applicationProperties;
        Properties result = new Properties();
        Properties platformProperties = DWPropertiesUtils.getPlatformProperties(PLATORM_CONFIG_PROPERTIES);
        if (platformProperties != null) {
            result.putAll((Map<?, ?>)platformProperties);
        }
        if ((applicationProperties = DWPropertiesUtils.getApplicationProperties(APPLICATION_CONFIG_PROPERTIES)) != null) {
            result.putAll((Map<?, ?>)applicationProperties);
        }
        if ((industryProperties = DWPropertiesUtils.getIndustryProperties(APPLICATION_CONFIG_PROPERTIES)) != null) {
            result.putAll((Map<?, ?>)industryProperties);
        }
        if ((customizationProperties = DWPropertiesUtils.getCustomizationProperties(APPLICATION_CONFIG_PROPERTIES)) != null) {
            result.putAll((Map<?, ?>)customizationProperties);
        }
        return result;
    }

    public static String getProperty(String key) {
        return DWApplicationConfigUtils.getProperty(key, null);
    }

    public static String getProperty(String key, String defaultValue) {
        String result = defaultValue;
        String searchValue = null;
        searchValue = DWPropertiesUtils.getProperty("${adapterPath}", "${adapterProperties}", key, defaultValue);
        if (searchValue != null) {
            return searchValue;
        }
        searchValue = DWPropertiesUtils.getCustomizationProperty(APPLICATION_CONFIG_PROPERTIES, key);
        if (searchValue != null) {
            return searchValue;
        }
        searchValue = DWPropertiesUtils.getIndustryProperty(APPLICATION_CONFIG_PROPERTIES, key);
        if (searchValue != null) {
            return searchValue;
        }
        searchValue = DWPropertiesUtils.getApplicationProperty(APPLICATION_CONFIG_PROPERTIES, key);
        if (searchValue != null) {
            return searchValue;
        }
        searchValue = DWPropertiesUtils.getPlatformProperty(PLATORM_CONFIG_PROPERTIES, key);
        if (searchValue != null) {
            return searchValue;
        }
        return result;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        return DWApplicationConfigUtils.getProperty(placeholder);
    }

    public static boolean isClosedDB() {
        boolean result = false;
        String dbUrl = DWApplicationConfigUtils.getProperty("dbUrl");
        if (dbUrl == null || dbUrl.trim().equals("")) {
            result = true;
        }
        return result;
    }

    public static boolean isClosedSchedule() {
        boolean result = false;
        if (DWApplicationConfigUtils.isClosedDB()) {
            return true;
        }
        String scheduleEnabled = DWApplicationConfigUtils.getProperty("scheduleEnabled", "false");
        if (scheduleEnabled.equals("false")) {
            result = true;
        }
        return result;
    }

    public static boolean isClosedCache() {
        boolean result = false;
        String redisHost = DWApplicationConfigUtils.getProperty("spring.redis.host");
        if (redisHost == null || redisHost.trim().equals("")) {
            result = true;
        }
        return result;
    }

    public static boolean isClosedTracing() {
        boolean result = false;
        String dwTracingEnabled = DWApplicationConfigUtils.getProperty("dwTracingEnabled");
        String dwTracingServerUrl = DWApplicationConfigUtils.getProperty("dwTracingServerUrl");
        if (dwTracingEnabled != null && dwTracingEnabled.equals("false")) {
            result = true;
        }
        if (dwTracingServerUrl == null || dwTracingServerUrl.trim().equals("")) {
            result = true;
        }
        return result;
    }

    public static boolean isClosedEAIAutoRegistration() {
        boolean result = false;
        String enable = DWApplicationConfigUtils.getProperty("eaiAutoRegistrationEnable");
        result = enable == null || enable.trim().equals("") ? true : Boolean.valueOf(enable) == false;
        return result;
    }
}

