/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.config.remote;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.config.ConfigType;
import java.io.File;

public class ConfigInfo {
    private ConfigType configType = null;
    private String fileNameWithoutExtension = null;
    private String modifiedFileName = null;

    public ConfigType getConfigType() {
        return this.configType;
    }

    public void setConfigType(ConfigType configType) {
        this.configType = configType;
    }

    public String getFileNameWithoutExtension() {
        return this.fileNameWithoutExtension;
    }

    public void setFileNameWithoutExtension(String fileNameWithoutExtension) {
        this.fileNameWithoutExtension = fileNameWithoutExtension;
    }

    public String getModifiedFileName() {
        return this.modifiedFileName;
    }

    public void setModifiedFileName(String modifiedFileName) {
        this.modifiedFileName = modifiedFileName;
    }

    public static ConfigInfo get(String path, String fileNameWithoutExtension) {
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setFileNameWithoutExtension(fileNameWithoutExtension);
        if (path.contains("industry") || path.contains("customization")) {
            return null;
        }
        if (DWPathUtils.isApplicationConfPath(path)) {
            configInfo.setModifiedFileName(fileNameWithoutExtension);
            configInfo.setConfigType(ConfigType.APPLICATION);
        } else if (DWPathUtils.isApplicationModuleConfPath(path)) {
            String module = path.replace(DWPathUtils.getApplicationModulePath() + File.separator, "").replace(File.separator + "conf", "");
            configInfo.setModifiedFileName(module + "." + fileNameWithoutExtension);
            configInfo.setConfigType(ConfigType.MODULE);
        } else if (DWPathUtils.isPlatformConfPath(path)) {
            configInfo.setModifiedFileName(fileNameWithoutExtension);
            configInfo.setConfigType(ConfigType.PLATFORM);
        } else if (DWPathUtils.isPlatformModuleConfPath(path)) {
            String module = path.replace(DWPathUtils.getPlatformModulePath() + File.separator, "").replace(File.separator + "conf", "");
            configInfo.setModifiedFileName(module + "." + fileNameWithoutExtension);
            configInfo.setConfigType(ConfigType.PLATFORM);
        }
        return configInfo;
    }
}

