/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor;

import com.digiwin.app.merge.processor.DWSourceAppProcessContext;
import com.digiwin.app.service.DWServiceContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class DWSourceAppLoopProcessor<T, R> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, R> process(List<T> dataList, Function<T, String> groupFunction) {
        Map<String, List<T>> groupResult = this.group(dataList, groupFunction);
        String currentAppId = DWServiceContext.getContext().get("$merge-deployment.current-app-id", null);
        DWSourceAppProcessContext<T, R> context = new DWSourceAppProcessContext<T, R>();
        for (Map.Entry<String, List<T>> item : groupResult.entrySet()) {
            context.setAppDataList(item.getKey(), item.getValue());
            this.beforeUnitProcess(context);
            if (context.isSkipProcess()) continue;
            try {
                DWServiceContext.getContext().set("$merge-deployment.current-app-id", item.getKey());
                R appProcessResult = this.unitProcess(item.getKey(), item.getValue());
                context.putResult(item.getKey(), appProcessResult);
            }
            finally {
                DWServiceContext.getContext().set("$merge-deployment.current-app-id", currentAppId);
            }
        }
        return context.getProcessHistory();
    }

    protected void beforeUnitProcess(DWSourceAppProcessContext<T, R> context) {
    }

    private Map<String, List<T>> group(List<T> dataList, Function<T, String> groupFunction) {
        LinkedHashMap<String, List<T>> groupResult = new LinkedHashMap<String, List<T>>();
        for (T item : dataList) {
            String appId = groupFunction.apply(item);
            List appDatas = groupResult.computeIfAbsent(appId, k -> new ArrayList());
            appDatas.add(item);
        }
        return groupResult;
    }

    public abstract R unitProcess(String var1, List<T> var2);

    public abstract void summary(Map<String, R> var1);

    public static class SourceAppProcessData<T> {
        private List<T> dataList;

        public SourceAppProcessData(List<T> dataList) {
            this.dataList = dataList;
        }

        private Map<String, List<T>> group(Function<T, String> groupFunction) {
            LinkedHashMap<String, List<T>> groupResult = new LinkedHashMap<String, List<T>>();
            for (T item : this.dataList) {
                String appId = groupFunction.apply(item);
                List appDatas = groupResult.computeIfAbsent(appId, k -> new ArrayList());
                appDatas.add(item);
            }
            return groupResult;
        }
    }
}

