/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge;

import com.digiwin.app.merge.DWAppMergedInfo;
import com.digiwin.app.merge.DWSourceAppInfo;
import com.digiwin.app.service.DWServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWSourceAppAwareUtils {
    public static final String CONFIG_KEY_APP_ID = "appId";
    public static final String PREFIX_MERGED_APPS = "dap.merged.apps";
    public static final String SERVICE_CONTEXT_DATA_KEY_CURRENT_APP_ID = "$merge-deployment.current-app-id";
    public static final String FORMAT_SOURCE_APP_AWARE_CONFIG_KEY = "dap.merged.apps.%s.%s";
    public static DWAppMergedInfo appMergedInfo;
    private static boolean multipleAppEnvironment;

    public static void setMultipleAppEnvironment(boolean multipleAppEnvironment) {
        DWSourceAppAwareUtils.multipleAppEnvironment = multipleAppEnvironment;
    }

    public static boolean isMultipleAppEnvironment() {
        return multipleAppEnvironment;
    }

    public static void setAppMergedInfo(boolean multipleAppEnvironment, DWAppMergedInfo appMergedInfo) {
        if (DWSourceAppAwareUtils.appMergedInfo == null && appMergedInfo != null) {
            Log log = LogFactory.getLog(DWSourceAppAwareUtils.class);
            log.info((Object)"DWSourceAppAwareUtils is ready for use!");
            log.info((Object)("Support config keys: " + String.valueOf(appMergedInfo.getSourceAppAwareConfigKeys())));
        }
        DWSourceAppAwareUtils.appMergedInfo = appMergedInfo;
        DWSourceAppAwareUtils.multipleAppEnvironment = multipleAppEnvironment;
    }

    public static DWAppMergedInfo getAppMergedInfo() {
        return appMergedInfo;
    }

    private static DWAppMergedInfo getAppMergedInfo(String requestSource) {
        return appMergedInfo;
    }

    public static boolean isAppIDConfigKey(String key) {
        return CONFIG_KEY_APP_ID.equals(key);
    }

    public static String getSourceAppConfigKey(String key) {
        String groupName = DWServiceContext.getContext().getGroupName();
        DWAppMergedInfo actualAppMergedInfo = DWSourceAppAwareUtils.getAppMergedInfo("configKey:" + key);
        if (actualAppMergedInfo == null) {
            return key;
        }
        DWSourceAppInfo sourceAppInfo = actualAppMergedInfo.getOwnerApp(groupName);
        if (actualAppMergedInfo.isTargetApp(sourceAppInfo.getAppId())) {
            return key;
        }
        if (actualAppMergedInfo.getSourceAppAwareConfigKeys().contains(key)) {
            return String.format(FORMAT_SOURCE_APP_AWARE_CONFIG_KEY, sourceAppInfo.getAppId(), key);
        }
        return key;
    }

    public static void switchContextAppId(String appId) {
        if (appId == null) {
            DWServiceContext.getContext().remove(SERVICE_CONTEXT_DATA_KEY_CURRENT_APP_ID);
        } else {
            DWServiceContext.getContext().set(SERVICE_CONTEXT_DATA_KEY_CURRENT_APP_ID, appId);
        }
    }

    public static String getContextAppId() {
        return (String)DWServiceContext.getContext().get(SERVICE_CONTEXT_DATA_KEY_CURRENT_APP_ID);
    }

    public static void clearContextAppId() {
        DWServiceContext.getContext().remove(SERVICE_CONTEXT_DATA_KEY_CURRENT_APP_ID);
    }

    public static String getCurrentAppId() {
        String contextAppId = DWServiceContext.getContext().get(SERVICE_CONTEXT_DATA_KEY_CURRENT_APP_ID, null);
        if (contextAppId == null) {
            String groupName = DWServiceContext.getContext().getGroupName();
            DWAppMergedInfo appMergedInfo = DWSourceAppAwareUtils.getAppMergedInfo("method:getCurrentAppId");
            if (appMergedInfo == null) {
                return null;
            }
            return appMergedInfo.getOwnerApp(groupName).getAppId();
        }
        return contextAppId;
    }

    public static String getCurrentAppToken() {
        DWSourceAppInfo sourceAppInfo;
        String currentAppId = DWSourceAppAwareUtils.getCurrentAppId();
        DWAppMergedInfo appMergedInfo = DWSourceAppAwareUtils.getAppMergedInfo("method:getCurrentAppToken");
        if (currentAppId == null) {
            String groupName = DWServiceContext.getContext().getGroupName();
            if (appMergedInfo == null) {
                return null;
            }
            sourceAppInfo = appMergedInfo.getOwnerApp(groupName);
        } else {
            sourceAppInfo = appMergedInfo.getSourceInfo(currentAppId);
        }
        return sourceAppInfo == null ? null : sourceAppInfo.getAppToken();
    }

    public static String getSourceAppId(String groupName) {
        DWAppMergedInfo appInfo = DWSourceAppAwareUtils.getAppMergedInfo("group:" + groupName);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getOwnerApp(groupName).getAppId();
    }

    static {
        multipleAppEnvironment = false;
    }
}

