/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient;

import com.digiwin.app.persistconn.DWPersistconnClientBuilder;
import com.digiwin.app.persistconn.TenantIdProvider;
import com.digiwin.app.persistconn.client.DWPersistconnClient;
import com.digiwin.app.queue.Command;
import com.digiwin.app.queue.DWQueueApplicationContextProvider;
import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.app.queue.DWQueueTopicManager;
import com.digiwin.app.queue.TopicBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

public class TenantAdminServiceClient {
    private static final String TAG = "[TenantAdminServiceClient] ";
    private static Log log = LogFactory.getLog(TenantAdminServiceClient.class);

    public String registerGateway(String userId, String password, String gatewayName, String apName) throws Exception {
        DWPersistconnClient persistconnClient = new DWPersistconnClientBuilder().toSaas().register(userId, password, gatewayName, apName).build();
        String result = persistconnClient.invoke();
        return result;
    }

    public String reRegisterGateway(String gatewayId, String gatewayName, String apName) throws Exception {
        log.info((Object)"[TenantAdminServiceClient] reRegisterGateway start");
        DWPersistconnClient persistconnClient = new DWPersistconnClientBuilder().toSaas().reRegister(gatewayId, gatewayName, apName).build();
        String reRegisterResult = persistconnClient.invoke();
        JSONObject jo = new JSONObject(reRegisterResult);
        boolean result = jo.getBoolean("result");
        String message = jo.getString("description");
        log.info((Object)(TAG + String.format("reRegister: %b, description: %s", result, message)));
        return reRegisterResult;
    }

    public String reRegisterGateway(String gatewayId, String gatewayName, String apName, int retryTimes, int intervalSec) throws Exception {
        log.info((Object)("[TenantAdminServiceClient] retryTimes: " + retryTimes + ", intervalSec: " + intervalSec));
        String reRegisterResult = this.reRegisterGateway(gatewayId, gatewayName, apName);
        JSONObject jo = new JSONObject(reRegisterResult);
        boolean result = jo.getBoolean("result");
        if (result || retryTimes == 0) {
            return reRegisterResult;
        }
        int retryCount = 0;
        while (!result) {
            log.info((Object)("[TenantAdminServiceClient] reRegister retry: " + ++retryCount));
            reRegisterResult = this.reRegisterGateway(gatewayId, gatewayName, apName);
            jo = new JSONObject(reRegisterResult);
            result = jo.getBoolean("result");
            if (result || retryCount == retryTimes) break;
            Thread.sleep(intervalSec * 1000);
        }
        return reRegisterResult;
    }

    public void registerTopic(String gatewayId, Command command, DWQueueReceiver receiver) throws Exception {
        String tenantId = TenantIdProvider.getTenantId();
        String topic = new TopicBuilder(tenantId, gatewayId).setNext(command.toString()).build();
        ApplicationContext context = DWQueueApplicationContextProvider.getApplicationContext();
        DWQueueTopicManager topicManager = (DWQueueTopicManager)context.getBean(DWQueueTopicManager.class);
        topicManager.register(topic, receiver);
    }
}

