/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient;

import com.digiwin.app.eai.DWEAI;
import com.digiwin.app.eai.DWEAIBuilder;
import com.digiwin.app.persistconn.DWResourcePojo;
import com.digiwin.app.persistconn.client.InvokeDapService;
import com.digiwin.app.persistconn.client.InvokeOtherDapService;
import com.digiwin.app.persistconn.client.InvokeSaasService;
import com.digiwin.app.persistconn.client.InvokeTenantDapService;
import com.digiwin.app.persistconn.client.InvokeThisDapService;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ServiceClient {
    private String digiHostAcct;
    private Map<String, String> customHeader = new HashMap<String, String>();
    private Map<String, String> customCallbackHeader = new HashMap<String, String>();

    public String invokeSaasService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeSaasService client = new InvokeSaasService(pojo);
        String result = client.invoke();
        return result;
    }

    public String invokeThisDapService(String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(moduleName, serviceName, methodName, parameter);
        InvokeThisDapService client = new InvokeThisDapService(pojo);
        String result = client.invoke();
        return result;
    }

    public String invokeOtherDapService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeOtherDapService client = new InvokeOtherDapService(pojo);
        String result = client.invoke();
        return result;
    }

    public String invokeDapService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeDapService client = new InvokeDapService(pojo);
        String result = client.invoke();
        return result;
    }

    public String invokeTenantDapService(String gatewayId, String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter, Integer timeout, TimeUnit timeoutUnit) throws Exception {
        DWResourcePojo pojo = new DWResourcePojo(apName, moduleName, serviceName, methodName, parameter);
        InvokeTenantDapService client = new InvokeTenantDapService(gatewayId, pojo, timeout, timeoutUnit);
        String result = client.invoke();
        return result;
    }

    public String invokeTenantDapService(String gatewayId, String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        return this.invokeTenantDapService(gatewayId, apName, moduleName, serviceName, methodName, parameter, -1, TimeUnit.SECONDS);
    }

    public String invokeTenantEaiService(String site_id, String prod, String name, String uid, Map<String, Object> parameter) throws Exception {
        DWEAIBuilder dwEAIBuilder = new DWEAIBuilder(site_id, prod, name, parameter).setDigiServiceUid(uid).setCustomHeader(this.customHeader).setCustomCallbackHeader(this.customCallbackHeader).sync();
        if (StringUtils.isNotBlank((CharSequence)this.digiHostAcct)) {
            dwEAIBuilder = dwEAIBuilder.setDigiHostAcct(this.digiHostAcct);
        }
        DWEAI dwEAI = dwEAIBuilder.build();
        Map result = dwEAI.execute();
        return new Gson().toJson((Object)result);
    }

    public String invokeTenantEaiServiceAsync(String site_id, String prod, String name, String uid, Map<String, Object> parameter, String callbackId) throws Exception {
        DWEAIBuilder dwEAIBuilder = new DWEAIBuilder(site_id, prod, name, parameter).setDigiServiceUid(uid).setCustomHeader(this.customHeader).setCustomCallbackHeader(this.customCallbackHeader).async(callbackId);
        if (StringUtils.isNotBlank((CharSequence)this.digiHostAcct)) {
            dwEAIBuilder = dwEAIBuilder.setDigiHostAcct(this.digiHostAcct);
        }
        DWEAI dwEAI = dwEAIBuilder.build();
        Map result = dwEAI.execute();
        return new Gson().toJson((Object)result);
    }

    public void setDigiHostAcct(String digiHostAcct) {
        this.digiHostAcct = digiHostAcct;
    }

    public void setCustomHeader(Map<String, String> customHeader) {
        this.customHeader = customHeader;
    }

    public void setCustomCallbackHeader(Map<String, String> customCallbackHeader) {
        this.customCallbackHeader = customCallbackHeader;
    }
}

