/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.persistconn.ApInfoProvider;
import com.digiwin.app.persistconn.SimpleReceiver;
import com.digiwin.app.persistconn.TenantIdProvider;
import com.digiwin.app.persistconn.TokenProvider;
import com.digiwin.app.persistconn.client.ReRegisterV01;
import com.digiwin.app.persistconn.client.Register;
import com.digiwin.app.persistconn.client.RegisterTopicV01;
import com.digiwin.app.persistconn.client.RegisterV01;
import com.digiwin.app.queue.Command;
import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.app.serviceclient.exception.ConnAuthKeyException;
import com.digiwin.app.serviceclient.exception.OperationException;
import com.digiwin.app.serviceclient.util.ServiceClientUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class TenantAdminServiceClient {
    private static Log log = LogFactory.getLog(TenantAdminServiceClient.class);
    private static final String TAG = "[TenantAdminServiceClient] ";

    public String simpleRegisterGateway(String gatewayName, String apName) {
        SimpleReceiver simpleReceiver = new SimpleReceiver();
        return this.registerGateway(gatewayName, apName, (DWQueueReceiver)simpleReceiver);
    }

    public String registerGateway(String gatewayName, String apName, DWQueueReceiver receiver) {
        String connAuthKeyPath = null;
        try {
            connAuthKeyPath = DWPathUtils.getConnAuthKeyPath();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new ConnAuthKeyException(e);
        }
        String encodedConnAuthKey = null;
        try {
            encodedConnAuthKey = new String(Files.readAllBytes(Paths.get(connAuthKeyPath, new String[0])));
        }
        catch (IOException e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new ConnAuthKeyException(e);
        }
        if (StringUtils.isBlank((CharSequence)encodedConnAuthKey)) {
            log.error((Object)"[TenantAdminServiceClient] no ConnAuthKey");
            throw new ConnAuthKeyException("no ConnAuthKey");
        }
        byte[] base64decodedBytes = Base64.getDecoder().decode(encodedConnAuthKey);
        String connAuthKey = new String(base64decodedBytes, StandardCharsets.UTF_8);
        Register client = new Register(gatewayName, apName, connAuthKey, receiver);
        String result = null;
        try {
            result = client.invoke();
        }
        catch (Exception e) {
            ServiceClientUtil.logStackTrace(log, e);
            throw new OperationException(e);
        }
        JSONObject jo = new JSONObject(result);
        boolean registerResult = jo.optBoolean("result", false);
        if (!registerResult) {
            log.error((Object)"[TenantAdminServiceClient] register gateway failed");
        }
        String tenantId = jo.optString("tenantId", "");
        String tenantSid = jo.optString("tenantSid", "");
        String token = jo.optString("token", "");
        TenantIdProvider.setTenantId((String)tenantId);
        TenantIdProvider.setTenantSid((String)tenantSid);
        TokenProvider.setToken((String)token);
        return result;
    }

    @Deprecated
    public String registerGateway(String userId, String password, String gatewayName, String apName) throws Exception {
        ApInfoProvider.setGatewayName((String)gatewayName);
        ApInfoProvider.setApName((String)apName);
        RegisterV01 client = new RegisterV01(userId, password, gatewayName, apName);
        String result = client.invoke();
        JSONObject jo = new JSONObject(result);
        boolean registerResult = jo.optBoolean("result", false);
        if (!registerResult) {
            log.error((Object)"[TenantAdminServiceClient] register gateway failed");
        }
        String tenantId = jo.optString("tenantId", "");
        TenantIdProvider.setTenantId((String)tenantId);
        return result;
    }

    @Deprecated
    public String reRegisterGateway(String gatewayId, String gatewayName, String apName) throws Exception {
        return this.reRegisterGateway(gatewayId, gatewayName, apName, -1, -1);
    }

    @Deprecated
    public String reRegisterGateway(String gatewayId, String gatewayName, String apName, int retryTimes, int retryIntervalSec) throws Exception {
        ApInfoProvider.setGatewayName((String)gatewayName);
        ApInfoProvider.setApName((String)apName);
        ReRegisterV01 client = new ReRegisterV01(gatewayId, gatewayName, apName, retryTimes, retryIntervalSec);
        String result = client.invoke();
        JSONObject jo = new JSONObject(result);
        boolean registerResult = jo.optBoolean("result", false);
        if (!registerResult) {
            log.error((Object)"[TenantAdminServiceClient] register gateway failed");
        }
        String tenantId = jo.optString("tenantId", "");
        TenantIdProvider.setTenantId((String)tenantId);
        return result;
    }

    @Deprecated
    public void registerTopic(String gatewayId, Command command, DWQueueReceiver receiver) throws Exception {
        String gatewayName = ApInfoProvider.getGatewayName();
        String apName = ApInfoProvider.getApName();
        RegisterTopicV01 client = new RegisterTopicV01(gatewayId, gatewayName, apName, receiver);
        client.invoke();
    }
}

