/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.exception;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWInvocationException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.gateway.output.StandardExceptionOutput;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.http.HttpStatus;

public class DWLocalInvocationException
extends DWInvocationException {
    private String standardErrorResult;

    public DWLocalInvocationException(String message, Throwable cause) {
        super(message, cause);
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        if (cause instanceof DWException) {
            httpStatus = HttpStatus.BAD_REQUEST;
        }
        Map standardErrorMessage = StandardExceptionOutput.getStandardErrorResult((HttpStatus)httpStatus, (Throwable)cause);
        this.standardErrorResult = DWGsonProvider.getGson().toJson((Object)standardErrorMessage, standardErrorMessage.getClass());
    }

    public <T> T getEntity(Type entityTypeOfT) {
        Object entity = null;
        Gson gson = DWGsonProvider.getGson();
        if (entityTypeOfT == String.class) {
            return (T)this.standardErrorResult;
        }
        entity = gson.fromJson(this.standardErrorResult, entityTypeOfT);
        return (T)entity;
    }

    public <T> T getEntity(Class<T> entityType) {
        return this.getEntity((Type)entityType);
    }
}

