/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigurer.simplified;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWServiceBuilder;
import com.digiwin.app.service.DWServiceDefinitionParser;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.simplified.DWGroupServiceLookupProcessor;
import com.digiwin.app.service.simplified.spring.DWSimplifiedSpringServiceBuilder;
import com.digiwin.resource.simplified.DWSimplifiedResourceManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class})
@ConditionalOnClass(value={DWGroupServiceLookupProcessor.class})
public class DWSimplifiedServiceLookupAutoConfiguration {
    @Bean(value={"dw-service-builder"})
    public DWServiceBuilder getServiceBuilder() {
        DWSimplifiedSpringServiceBuilder builder = new DWSimplifiedSpringServiceBuilder();
        DWServiceInfo.setServiceBuilder((DWServiceBuilder)builder);
        return builder;
    }

    @Bean(value={"dw-group-resource-manager"})
    public DWSimplifiedResourceManager getGroupResourceManager(Environment environment) {
        String excludeGroupString = environment.getProperty("dap.group.exclude");
        List excludeGroupList = excludeGroupString == null ? Collections.emptyList() : Arrays.asList(excludeGroupString.split(","));
        return new DWSimplifiedResourceManager(excludeGroupList);
    }

    @Bean(value={"dw-service-lookup-processor"})
    public DWGroupServiceLookupProcessor getServiceLookupProcessor(List<DWServiceDefinitionParser> serviceDefParsers, DWSimplifiedResourceManager groupResourceManager, @Nullable DWServiceCommonsProvider serviceCommonsProvider) {
        DWGroupServiceLookupProcessor processor = new DWGroupServiceLookupProcessor(serviceDefParsers, groupResourceManager);
        if (serviceCommonsProvider != null) {
            processor.setCommonsInterfaces(serviceCommonsProvider.getInterfaceServices());
            processor.setCommonsImplements(serviceCommonsProvider.getImplementServices());
        }
        return processor;
    }
}

