/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigurer.simplified.context;

import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.resource.simplified.spring.DWSimplifiedApplicationMessageSource;
import com.digiwin.resource.simplified.spring.DWSimplifiedServiceGroupMessageSource;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.context.MessageSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={MessageSourceAutoConfiguration.class})
@ConditionalOnClass(value={DWSimplifiedApplicationMessageSource.class})
@ConditionalOnMissingBean(name={"messageSource"}, search=SearchStrategy.CURRENT)
public class DWSimplifiedMessageSourceAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.messages")
    public MessageSourceProperties messageSourceProperties() {
        return new MessageSourceProperties();
    }

    @Bean(value={"messageSource"})
    public MessageSource messageSource() {
        MessageSourceProperties springMessageSourceProperties = this.messageSourceProperties();
        String baseName = springMessageSourceProperties.getBasename();
        String[] extraBaseNames = null;
        if (StringUtils.hasText((String)springMessageSourceProperties.getBasename())) {
            extraBaseNames = StringUtils.commaDelimitedListToStringArray((String)springMessageSourceProperties.getBasename());
            for (int i = 0; i < extraBaseNames.length; ++i) {
                extraBaseNames[i] = extraBaseNames[i].trim();
            }
        }
        DWSimplifiedApplicationMessageSource applicationMessageSource = new DWSimplifiedApplicationMessageSource(extraBaseNames);
        DWSimplifiedServiceGroupMessageSource groupMessageSource = new DWSimplifiedServiceGroupMessageSource();
        groupMessageSource.setParentMessageSource((MessageSource)applicationMessageSource);
        DWApplicationMessageResourceBundleUtils.setMessageSource((MessageSource)applicationMessageSource);
        return groupMessageSource;
    }
}

