/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigurer.simplified;

import com.digiwin.app.validation.simplified.DWSimplifiedResourceBundleLocator;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ValidatorFactory;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;

@Configuration
@AutoConfigureBefore(name={"org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration"})
public class DWSimplifiedValidationAutoConfiguration {
    @Bean(name={"dao-LocalValidatorFactoryBean"})
    public static LocalValidatorFactoryBean getLocalValidatorFactoryBean() {
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        DWSimplifiedResourceBundleLocator rbLocator = new DWSimplifiedResourceBundleLocator();
        ResourceBundleMessageInterpolator interpolator = new ResourceBundleMessageInterpolator((ResourceBundleLocator)rbLocator);
        factoryBean.setMessageInterpolator((MessageInterpolator)interpolator);
        return factoryBean;
    }

    @Bean(name={"dao-MethodValidationPostProcessor"})
    public static MethodValidationPostProcessor getMethodValidationPostProcessor(@Autowired @Qualifier(value="dao-LocalValidatorFactoryBean") LocalValidatorFactoryBean factoryBean) {
        MethodValidationPostProcessor processor = new MethodValidationPostProcessor();
        processor.setValidatorFactory((ValidatorFactory)factoryBean);
        return processor;
    }
}

